/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator.utils;

import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.client.CustomResource;
import io.sundr.builder.TypedVisitor;
import io.sundr.builder.Visitor;
import io.sundr.codegen.functions.ClassTo;
import io.sundr.codegen.model.ClassRef;
import io.sundr.codegen.model.Property;
import io.sundr.codegen.model.PropertyBuilder;
import io.sundr.codegen.model.TypeDef;
import io.sundr.codegen.model.TypeDefBuilder;
import io.sundr.codegen.model.TypeParamDef;
import io.sundr.codegen.model.TypeParamRef;
import io.sundr.codegen.model.TypeRef;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Types {
    private static final TypeDef NAMESPACED = (TypeDef)ClassTo.TYPEDEF.apply(Namespaced.class);
    private static final TypeDef CUSTOM_RESOURCE = (TypeDef)ClassTo.TYPEDEF.apply(CustomResource.class);

    public static List<Property> allProperties(TypeDef typeDef) {
        return Types.unrollHierarchy(typeDef).stream().flatMap(h -> h.getProperties().stream()).collect(Collectors.toList());
    }

    public static Set<TypeDef> unrollHierarchy(TypeDef typeDef) {
        if (typeDef.getPackageName() != null && (typeDef.getPackageName().startsWith("java.") || typeDef.getPackageName().startsWith("javax.") || typeDef.getPackageName().startsWith("com.sun.") || typeDef.getPackageName().startsWith("com.ibm."))) {
            return new HashSet<TypeDef>();
        }
        if (typeDef.getFullyQualifiedName().equals(CUSTOM_RESOURCE.getFullyQualifiedName())) {
            return Stream.of(((TypeDefBuilder)new TypeDefBuilder(CUSTOM_RESOURCE).withProperties(typeDef.getProperties().stream().filter(p -> p.getName().equals("spec") || p.getName().equals("status")).collect(Collectors.toList()))).build()).collect(Collectors.toSet());
        }
        HashSet<TypeDef> hierarchy = new HashSet<TypeDef>();
        hierarchy.add(typeDef);
        hierarchy.addAll(typeDef.getExtendsList().stream().flatMap(s -> Types.unrollHierarchy(Types.applyTypeArguments(s)).stream()).collect(Collectors.toSet()));
        return hierarchy;
    }

    public static TypeDef applyTypeArguments(ClassRef ref) {
        final HashMap<String, TypeRef> bounds = new HashMap<String, TypeRef>();
        List arguments = ref.getArguments();
        TypeDef definition = ref.getDefinition();
        List parameters = definition.getParameters();
        if (arguments.size() == parameters.size()) {
            for (int i = 0; i < arguments.size(); ++i) {
                bounds.put(((TypeParamDef)parameters.get(i)).getName(), (TypeRef)arguments.get(i));
            }
            return ((TypeDefBuilder)new TypeDefBuilder(definition).accept(new Visitor[]{new TypedVisitor<PropertyBuilder>(){

                public void visit(PropertyBuilder property) {
                    TypeRef paramRef;
                    TypeParamRef typeParamRef;
                    String key;
                    TypeRef typeRef = property.buildTypeRef();
                    if (typeRef instanceof TypeParamRef && bounds.containsKey(key = (typeParamRef = (TypeParamRef)typeRef).getName()) && (paramRef = (TypeRef)bounds.get(key)) != null) {
                        property.withTypeRef(paramRef);
                    }
                }
            }})).build();
        }
        return new TypeDefBuilder(definition).build();
    }

    public static boolean isNamespaced(TypeDef definition) {
        return Types.isNamespaced(definition, new HashSet<TypeDef>());
    }

    public static boolean isNamespaced(TypeDef definition, Set<TypeDef> visited) {
        if (definition.getFullyQualifiedName().equals(NAMESPACED.getFullyQualifiedName())) {
            return true;
        }
        if (visited.contains(definition) || definition.getPackageName().startsWith("java.")) {
            return false;
        }
        HashSet<TypeDef> newVisited = new HashSet<TypeDef>(visited);
        newVisited.add(definition);
        for (ClassRef i : definition.getImplementsList()) {
            if (!Types.isNamespaced(i.getDefinition(), newVisited)) continue;
            return true;
        }
        for (ClassRef e : definition.getExtendsList()) {
            if (!Types.isNamespaced(e.getDefinition(), newVisited)) continue;
            return true;
        }
        return false;
    }

    public static Optional<Property> findStatusProperty(TypeDef typeDef) {
        return Types.allProperties(typeDef).stream().filter(Types::isStatusProperty).findFirst();
    }

    public static boolean isStatusProperty(Property property) {
        return "status".equals(property.getName());
    }
}

