/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.common.util;

import io.fabric8.common.util.ChecksumUtils;
import java.io.File;
import java.io.IOException;

public class FileChangeInfo {
    private final long length;
    private final long checksum;

    public FileChangeInfo(long length, long checksum) {
        this.length = length;
        this.checksum = checksum;
    }

    public static FileChangeInfo newInstance(File file) throws IOException {
        if (file != null && file.isFile() && file.exists()) {
            long checksum = ChecksumUtils.checksumFile(file);
            return new FileChangeInfo(file.length(), checksum);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileChangeInfo that = (FileChangeInfo)o;
        if (this.checksum != that.checksum) {
            return false;
        }
        return this.length == that.length;
    }

    public int hashCode() {
        int result = (int)(this.length ^ this.length >>> 32);
        result = 31 * result + (int)(this.checksum ^ this.checksum >>> 32);
        return result;
    }

    public long getLength() {
        return this.length;
    }

    public long getChecksum() {
        return this.checksum;
    }
}

