package io.fabric8.chaosmesh.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class RawTrafficControlFluent<A extends RawTrafficControlFluent<A>> extends BaseFluent<A>{
  public RawTrafficControlFluent() {
  }
  
  public RawTrafficControlFluent(RawTrafficControl instance) {
    this.copyInstance(instance);
  }
  private BandwidthSpecBuilder bandwidth;
  private CorruptSpecBuilder corrupt;
  private DelaySpecBuilder delay;
  private String device;
  private DuplicateSpecBuilder duplicate;
  private String ipset;
  private LossSpecBuilder loss;
  private String source;
  private String type;
  
  protected void copyInstance(RawTrafficControl instance) {
    instance = (instance != null ? instance : new RawTrafficControl());
    if (instance != null) {
          this.withBandwidth(instance.getBandwidth());
          this.withCorrupt(instance.getCorrupt());
          this.withDelay(instance.getDelay());
          this.withDevice(instance.getDevice());
          this.withDuplicate(instance.getDuplicate());
          this.withIpset(instance.getIpset());
          this.withLoss(instance.getLoss());
          this.withSource(instance.getSource());
          this.withType(instance.getType());
          this.withBandwidth(instance.getBandwidth());
          this.withCorrupt(instance.getCorrupt());
          this.withDelay(instance.getDelay());
          this.withDevice(instance.getDevice());
          this.withDuplicate(instance.getDuplicate());
          this.withIpset(instance.getIpset());
          this.withLoss(instance.getLoss());
          this.withSource(instance.getSource());
          this.withType(instance.getType());
        }
  }
  
  public BandwidthSpec buildBandwidth() {
    return this.bandwidth != null ? this.bandwidth.build() : null;
  }
  
  public A withBandwidth(BandwidthSpec bandwidth) {
    this._visitables.remove(this.bandwidth);
    if (bandwidth != null) {
        this.bandwidth = new BandwidthSpecBuilder(bandwidth);
        this._visitables.get("bandwidth").add(this.bandwidth);
    } else {
        this.bandwidth = null;
        this._visitables.get("bandwidth").remove(this.bandwidth);
    }
    return (A) this;
  }
  
  public boolean hasBandwidth() {
    return this.bandwidth != null;
  }
  
  public A withNewBandwidth(Integer buffer,Integer limit,Long minburst,Long peakrate,String rate) {
    return (A)withBandwidth(new BandwidthSpec(buffer, limit, minburst, peakrate, rate));
  }
  
  public BandwidthNested<A> withNewBandwidth() {
    return new BandwidthNested(null);
  }
  
  public BandwidthNested<A> withNewBandwidthLike(BandwidthSpec item) {
    return new BandwidthNested(item);
  }
  
  public BandwidthNested<A> editBandwidth() {
    return withNewBandwidthLike(java.util.Optional.ofNullable(buildBandwidth()).orElse(null));
  }
  
  public BandwidthNested<A> editOrNewBandwidth() {
    return withNewBandwidthLike(java.util.Optional.ofNullable(buildBandwidth()).orElse(new BandwidthSpecBuilder().build()));
  }
  
  public BandwidthNested<A> editOrNewBandwidthLike(BandwidthSpec item) {
    return withNewBandwidthLike(java.util.Optional.ofNullable(buildBandwidth()).orElse(item));
  }
  
  public CorruptSpec buildCorrupt() {
    return this.corrupt != null ? this.corrupt.build() : null;
  }
  
  public A withCorrupt(CorruptSpec corrupt) {
    this._visitables.remove(this.corrupt);
    if (corrupt != null) {
        this.corrupt = new CorruptSpecBuilder(corrupt);
        this._visitables.get("corrupt").add(this.corrupt);
    } else {
        this.corrupt = null;
        this._visitables.get("corrupt").remove(this.corrupt);
    }
    return (A) this;
  }
  
  public boolean hasCorrupt() {
    return this.corrupt != null;
  }
  
  public A withNewCorrupt(String correlation,String corrupt) {
    return (A)withCorrupt(new CorruptSpec(correlation, corrupt));
  }
  
  public CorruptNested<A> withNewCorrupt() {
    return new CorruptNested(null);
  }
  
  public CorruptNested<A> withNewCorruptLike(CorruptSpec item) {
    return new CorruptNested(item);
  }
  
  public CorruptNested<A> editCorrupt() {
    return withNewCorruptLike(java.util.Optional.ofNullable(buildCorrupt()).orElse(null));
  }
  
  public CorruptNested<A> editOrNewCorrupt() {
    return withNewCorruptLike(java.util.Optional.ofNullable(buildCorrupt()).orElse(new CorruptSpecBuilder().build()));
  }
  
  public CorruptNested<A> editOrNewCorruptLike(CorruptSpec item) {
    return withNewCorruptLike(java.util.Optional.ofNullable(buildCorrupt()).orElse(item));
  }
  
  public DelaySpec buildDelay() {
    return this.delay != null ? this.delay.build() : null;
  }
  
  public A withDelay(DelaySpec delay) {
    this._visitables.remove(this.delay);
    if (delay != null) {
        this.delay = new DelaySpecBuilder(delay);
        this._visitables.get("delay").add(this.delay);
    } else {
        this.delay = null;
        this._visitables.get("delay").remove(this.delay);
    }
    return (A) this;
  }
  
  public boolean hasDelay() {
    return this.delay != null;
  }
  
  public DelayNested<A> withNewDelay() {
    return new DelayNested(null);
  }
  
  public DelayNested<A> withNewDelayLike(DelaySpec item) {
    return new DelayNested(item);
  }
  
  public DelayNested<A> editDelay() {
    return withNewDelayLike(java.util.Optional.ofNullable(buildDelay()).orElse(null));
  }
  
  public DelayNested<A> editOrNewDelay() {
    return withNewDelayLike(java.util.Optional.ofNullable(buildDelay()).orElse(new DelaySpecBuilder().build()));
  }
  
  public DelayNested<A> editOrNewDelayLike(DelaySpec item) {
    return withNewDelayLike(java.util.Optional.ofNullable(buildDelay()).orElse(item));
  }
  
  public String getDevice() {
    return this.device;
  }
  
  public A withDevice(String device) {
    this.device = device;
    return (A) this;
  }
  
  public boolean hasDevice() {
    return this.device != null;
  }
  
  public DuplicateSpec buildDuplicate() {
    return this.duplicate != null ? this.duplicate.build() : null;
  }
  
  public A withDuplicate(DuplicateSpec duplicate) {
    this._visitables.remove(this.duplicate);
    if (duplicate != null) {
        this.duplicate = new DuplicateSpecBuilder(duplicate);
        this._visitables.get("duplicate").add(this.duplicate);
    } else {
        this.duplicate = null;
        this._visitables.get("duplicate").remove(this.duplicate);
    }
    return (A) this;
  }
  
  public boolean hasDuplicate() {
    return this.duplicate != null;
  }
  
  public A withNewDuplicate(String correlation,String duplicate) {
    return (A)withDuplicate(new DuplicateSpec(correlation, duplicate));
  }
  
  public DuplicateNested<A> withNewDuplicate() {
    return new DuplicateNested(null);
  }
  
  public DuplicateNested<A> withNewDuplicateLike(DuplicateSpec item) {
    return new DuplicateNested(item);
  }
  
  public DuplicateNested<A> editDuplicate() {
    return withNewDuplicateLike(java.util.Optional.ofNullable(buildDuplicate()).orElse(null));
  }
  
  public DuplicateNested<A> editOrNewDuplicate() {
    return withNewDuplicateLike(java.util.Optional.ofNullable(buildDuplicate()).orElse(new DuplicateSpecBuilder().build()));
  }
  
  public DuplicateNested<A> editOrNewDuplicateLike(DuplicateSpec item) {
    return withNewDuplicateLike(java.util.Optional.ofNullable(buildDuplicate()).orElse(item));
  }
  
  public String getIpset() {
    return this.ipset;
  }
  
  public A withIpset(String ipset) {
    this.ipset = ipset;
    return (A) this;
  }
  
  public boolean hasIpset() {
    return this.ipset != null;
  }
  
  public LossSpec buildLoss() {
    return this.loss != null ? this.loss.build() : null;
  }
  
  public A withLoss(LossSpec loss) {
    this._visitables.remove(this.loss);
    if (loss != null) {
        this.loss = new LossSpecBuilder(loss);
        this._visitables.get("loss").add(this.loss);
    } else {
        this.loss = null;
        this._visitables.get("loss").remove(this.loss);
    }
    return (A) this;
  }
  
  public boolean hasLoss() {
    return this.loss != null;
  }
  
  public A withNewLoss(String correlation,String loss) {
    return (A)withLoss(new LossSpec(correlation, loss));
  }
  
  public LossNested<A> withNewLoss() {
    return new LossNested(null);
  }
  
  public LossNested<A> withNewLossLike(LossSpec item) {
    return new LossNested(item);
  }
  
  public LossNested<A> editLoss() {
    return withNewLossLike(java.util.Optional.ofNullable(buildLoss()).orElse(null));
  }
  
  public LossNested<A> editOrNewLoss() {
    return withNewLossLike(java.util.Optional.ofNullable(buildLoss()).orElse(new LossSpecBuilder().build()));
  }
  
  public LossNested<A> editOrNewLossLike(LossSpec item) {
    return withNewLossLike(java.util.Optional.ofNullable(buildLoss()).orElse(item));
  }
  
  public String getSource() {
    return this.source;
  }
  
  public A withSource(String source) {
    this.source = source;
    return (A) this;
  }
  
  public boolean hasSource() {
    return this.source != null;
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RawTrafficControlFluent that = (RawTrafficControlFluent) o;
    if (!java.util.Objects.equals(bandwidth, that.bandwidth)) return false;
    if (!java.util.Objects.equals(corrupt, that.corrupt)) return false;
    if (!java.util.Objects.equals(delay, that.delay)) return false;
    if (!java.util.Objects.equals(device, that.device)) return false;
    if (!java.util.Objects.equals(duplicate, that.duplicate)) return false;
    if (!java.util.Objects.equals(ipset, that.ipset)) return false;
    if (!java.util.Objects.equals(loss, that.loss)) return false;
    if (!java.util.Objects.equals(source, that.source)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(bandwidth,  corrupt,  delay,  device,  duplicate,  ipset,  loss,  source,  type,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bandwidth != null) { sb.append("bandwidth:"); sb.append(bandwidth + ","); }
    if (corrupt != null) { sb.append("corrupt:"); sb.append(corrupt + ","); }
    if (delay != null) { sb.append("delay:"); sb.append(delay + ","); }
    if (device != null) { sb.append("device:"); sb.append(device + ","); }
    if (duplicate != null) { sb.append("duplicate:"); sb.append(duplicate + ","); }
    if (ipset != null) { sb.append("ipset:"); sb.append(ipset + ","); }
    if (loss != null) { sb.append("loss:"); sb.append(loss + ","); }
    if (source != null) { sb.append("source:"); sb.append(source + ","); }
    if (type != null) { sb.append("type:"); sb.append(type); }
    sb.append("}");
    return sb.toString();
  }
  public class BandwidthNested<N> extends BandwidthSpecFluent<BandwidthNested<N>> implements Nested<N>{
    BandwidthNested(BandwidthSpec item) {
      this.builder = new BandwidthSpecBuilder(this, item);
    }
    BandwidthSpecBuilder builder;
    
    public N and() {
      return (N) RawTrafficControlFluent.this.withBandwidth(builder.build());
    }
    
    public N endBandwidth() {
      return and();
    }
    
  
  }
  public class CorruptNested<N> extends CorruptSpecFluent<CorruptNested<N>> implements Nested<N>{
    CorruptNested(CorruptSpec item) {
      this.builder = new CorruptSpecBuilder(this, item);
    }
    CorruptSpecBuilder builder;
    
    public N and() {
      return (N) RawTrafficControlFluent.this.withCorrupt(builder.build());
    }
    
    public N endCorrupt() {
      return and();
    }
    
  
  }
  public class DelayNested<N> extends DelaySpecFluent<DelayNested<N>> implements Nested<N>{
    DelayNested(DelaySpec item) {
      this.builder = new DelaySpecBuilder(this, item);
    }
    DelaySpecBuilder builder;
    
    public N and() {
      return (N) RawTrafficControlFluent.this.withDelay(builder.build());
    }
    
    public N endDelay() {
      return and();
    }
    
  
  }
  public class DuplicateNested<N> extends DuplicateSpecFluent<DuplicateNested<N>> implements Nested<N>{
    DuplicateNested(DuplicateSpec item) {
      this.builder = new DuplicateSpecBuilder(this, item);
    }
    DuplicateSpecBuilder builder;
    
    public N and() {
      return (N) RawTrafficControlFluent.this.withDuplicate(builder.build());
    }
    
    public N endDuplicate() {
      return and();
    }
    
  
  }
  public class LossNested<N> extends LossSpecFluent<LossNested<N>> implements Nested<N>{
    LossNested(LossSpec item) {
      this.builder = new LossSpecBuilder(this, item);
    }
    LossSpecBuilder builder;
    
    public N and() {
      return (N) RawTrafficControlFluent.this.withLoss(builder.build());
    }
    
    public N endLoss() {
      return and();
    }
    
  
  }

}