package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PodNetworkChaosSpecFluent<A extends PodNetworkChaosSpecFluent<A>> extends BaseFluent<A>{
  public PodNetworkChaosSpecFluent() {
  }
  
  public PodNetworkChaosSpecFluent(PodNetworkChaosSpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<RawIPSetBuilder> ipsets = new ArrayList<RawIPSetBuilder>();
  private ArrayList<RawIptablesBuilder> iptables = new ArrayList<RawIptablesBuilder>();
  private ArrayList<RawTrafficControlBuilder> tcs = new ArrayList<RawTrafficControlBuilder>();
  
  protected void copyInstance(PodNetworkChaosSpec instance) {
    instance = (instance != null ? instance : new PodNetworkChaosSpec());
    if (instance != null) {
          this.withIpsets(instance.getIpsets());
          this.withIptables(instance.getIptables());
          this.withTcs(instance.getTcs());
          this.withIpsets(instance.getIpsets());
          this.withIptables(instance.getIptables());
          this.withTcs(instance.getTcs());
        }
  }
  
  public A addToIpsets(int index,RawIPSet item) {
    if (this.ipsets == null) {this.ipsets = new ArrayList<RawIPSetBuilder>();}
    RawIPSetBuilder builder = new RawIPSetBuilder(item);
    if (index < 0 || index >= ipsets.size()) { _visitables.get("ipsets").add(builder); ipsets.add(builder); } else { _visitables.get("ipsets").add(index, builder); ipsets.add(index, builder);}
    return (A)this;
  }
  
  public A setToIpsets(int index,RawIPSet item) {
    if (this.ipsets == null) {this.ipsets = new ArrayList<RawIPSetBuilder>();}
    RawIPSetBuilder builder = new RawIPSetBuilder(item);
    if (index < 0 || index >= ipsets.size()) { _visitables.get("ipsets").add(builder); ipsets.add(builder); } else { _visitables.get("ipsets").set(index, builder); ipsets.set(index, builder);}
    return (A)this;
  }
  
  public A addToIpsets(io.fabric8.chaosmesh.v1alpha1.RawIPSet... items) {
    if (this.ipsets == null) {this.ipsets = new ArrayList<RawIPSetBuilder>();}
    for (RawIPSet item : items) {RawIPSetBuilder builder = new RawIPSetBuilder(item);_visitables.get("ipsets").add(builder);this.ipsets.add(builder);} return (A)this;
  }
  
  public A addAllToIpsets(Collection<RawIPSet> items) {
    if (this.ipsets == null) {this.ipsets = new ArrayList<RawIPSetBuilder>();}
    for (RawIPSet item : items) {RawIPSetBuilder builder = new RawIPSetBuilder(item);_visitables.get("ipsets").add(builder);this.ipsets.add(builder);} return (A)this;
  }
  
  public A removeFromIpsets(io.fabric8.chaosmesh.v1alpha1.RawIPSet... items) {
    if (this.ipsets == null) return (A)this;
    for (RawIPSet item : items) {RawIPSetBuilder builder = new RawIPSetBuilder(item);_visitables.get("ipsets").remove(builder); this.ipsets.remove(builder);} return (A)this;
  }
  
  public A removeAllFromIpsets(Collection<RawIPSet> items) {
    if (this.ipsets == null) return (A)this;
    for (RawIPSet item : items) {RawIPSetBuilder builder = new RawIPSetBuilder(item);_visitables.get("ipsets").remove(builder); this.ipsets.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromIpsets(Predicate<RawIPSetBuilder> predicate) {
    if (ipsets == null) return (A) this;
    final Iterator<RawIPSetBuilder> each = ipsets.iterator();
    final List visitables = _visitables.get("ipsets");
    while (each.hasNext()) {
      RawIPSetBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<RawIPSet> buildIpsets() {
    return this.ipsets != null ? build(ipsets) : null;
  }
  
  public RawIPSet buildIpset(int index) {
    return this.ipsets.get(index).build();
  }
  
  public RawIPSet buildFirstIpset() {
    return this.ipsets.get(0).build();
  }
  
  public RawIPSet buildLastIpset() {
    return this.ipsets.get(ipsets.size() - 1).build();
  }
  
  public RawIPSet buildMatchingIpset(Predicate<RawIPSetBuilder> predicate) {
      for (RawIPSetBuilder item : ipsets) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingIpset(Predicate<RawIPSetBuilder> predicate) {
      for (RawIPSetBuilder item : ipsets) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withIpsets(List<RawIPSet> ipsets) {
    if (this.ipsets != null) {
      this._visitables.get("ipsets").clear();
    }
    if (ipsets != null) {
        this.ipsets = new ArrayList();
        for (RawIPSet item : ipsets) {
          this.addToIpsets(item);
        }
    } else {
      this.ipsets = null;
    }
    return (A) this;
  }
  
  public A withIpsets(io.fabric8.chaosmesh.v1alpha1.RawIPSet... ipsets) {
    if (this.ipsets != null) {this.ipsets.clear(); _visitables.remove("ipsets"); }
    if (ipsets != null) {for (RawIPSet item :ipsets){ this.addToIpsets(item);}} return (A) this;
  }
  
  public boolean hasIpsets() {
    return this.ipsets != null && !this.ipsets.isEmpty();
  }
  
  public IpsetsNested<A> addNewIpset() {
    return new IpsetsNested(-1, null);
  }
  
  public IpsetsNested<A> addNewIpsetLike(RawIPSet item) {
    return new IpsetsNested(-1, item);
  }
  
  public IpsetsNested<A> setNewIpsetLike(int index,RawIPSet item) {
    return new IpsetsNested(index, item);
  }
  
  public IpsetsNested<A> editIpset(int index) {
    if (ipsets.size() <= index) throw new RuntimeException("Can't edit ipsets. Index exceeds size.");
    return setNewIpsetLike(index, buildIpset(index));
  }
  
  public IpsetsNested<A> editFirstIpset() {
    if (ipsets.size() == 0) throw new RuntimeException("Can't edit first ipsets. The list is empty.");
    return setNewIpsetLike(0, buildIpset(0));
  }
  
  public IpsetsNested<A> editLastIpset() {
    int index = ipsets.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ipsets. The list is empty.");
    return setNewIpsetLike(index, buildIpset(index));
  }
  
  public IpsetsNested<A> editMatchingIpset(Predicate<RawIPSetBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ipsets.size();i++) { 
    if (predicate.test(ipsets.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ipsets. No match found.");
    return setNewIpsetLike(index, buildIpset(index));
  }
  
  public A addToIptables(int index,RawIptables item) {
    if (this.iptables == null) {this.iptables = new ArrayList<RawIptablesBuilder>();}
    RawIptablesBuilder builder = new RawIptablesBuilder(item);
    if (index < 0 || index >= iptables.size()) { _visitables.get("iptables").add(builder); iptables.add(builder); } else { _visitables.get("iptables").add(index, builder); iptables.add(index, builder);}
    return (A)this;
  }
  
  public A setToIptables(int index,RawIptables item) {
    if (this.iptables == null) {this.iptables = new ArrayList<RawIptablesBuilder>();}
    RawIptablesBuilder builder = new RawIptablesBuilder(item);
    if (index < 0 || index >= iptables.size()) { _visitables.get("iptables").add(builder); iptables.add(builder); } else { _visitables.get("iptables").set(index, builder); iptables.set(index, builder);}
    return (A)this;
  }
  
  public A addToIptables(io.fabric8.chaosmesh.v1alpha1.RawIptables... items) {
    if (this.iptables == null) {this.iptables = new ArrayList<RawIptablesBuilder>();}
    for (RawIptables item : items) {RawIptablesBuilder builder = new RawIptablesBuilder(item);_visitables.get("iptables").add(builder);this.iptables.add(builder);} return (A)this;
  }
  
  public A addAllToIptables(Collection<RawIptables> items) {
    if (this.iptables == null) {this.iptables = new ArrayList<RawIptablesBuilder>();}
    for (RawIptables item : items) {RawIptablesBuilder builder = new RawIptablesBuilder(item);_visitables.get("iptables").add(builder);this.iptables.add(builder);} return (A)this;
  }
  
  public A removeFromIptables(io.fabric8.chaosmesh.v1alpha1.RawIptables... items) {
    if (this.iptables == null) return (A)this;
    for (RawIptables item : items) {RawIptablesBuilder builder = new RawIptablesBuilder(item);_visitables.get("iptables").remove(builder); this.iptables.remove(builder);} return (A)this;
  }
  
  public A removeAllFromIptables(Collection<RawIptables> items) {
    if (this.iptables == null) return (A)this;
    for (RawIptables item : items) {RawIptablesBuilder builder = new RawIptablesBuilder(item);_visitables.get("iptables").remove(builder); this.iptables.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromIptables(Predicate<RawIptablesBuilder> predicate) {
    if (iptables == null) return (A) this;
    final Iterator<RawIptablesBuilder> each = iptables.iterator();
    final List visitables = _visitables.get("iptables");
    while (each.hasNext()) {
      RawIptablesBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<RawIptables> buildIptables() {
    return this.iptables != null ? build(iptables) : null;
  }
  
  public RawIptables buildIptable(int index) {
    return this.iptables.get(index).build();
  }
  
  public RawIptables buildFirstIptable() {
    return this.iptables.get(0).build();
  }
  
  public RawIptables buildLastIptable() {
    return this.iptables.get(iptables.size() - 1).build();
  }
  
  public RawIptables buildMatchingIptable(Predicate<RawIptablesBuilder> predicate) {
      for (RawIptablesBuilder item : iptables) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingIptable(Predicate<RawIptablesBuilder> predicate) {
      for (RawIptablesBuilder item : iptables) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withIptables(List<RawIptables> iptables) {
    if (this.iptables != null) {
      this._visitables.get("iptables").clear();
    }
    if (iptables != null) {
        this.iptables = new ArrayList();
        for (RawIptables item : iptables) {
          this.addToIptables(item);
        }
    } else {
      this.iptables = null;
    }
    return (A) this;
  }
  
  public A withIptables(io.fabric8.chaosmesh.v1alpha1.RawIptables... iptables) {
    if (this.iptables != null) {this.iptables.clear(); _visitables.remove("iptables"); }
    if (iptables != null) {for (RawIptables item :iptables){ this.addToIptables(item);}} return (A) this;
  }
  
  public boolean hasIptables() {
    return this.iptables != null && !this.iptables.isEmpty();
  }
  
  public IptablesNested<A> addNewIptable() {
    return new IptablesNested(-1, null);
  }
  
  public IptablesNested<A> addNewIptableLike(RawIptables item) {
    return new IptablesNested(-1, item);
  }
  
  public IptablesNested<A> setNewIptableLike(int index,RawIptables item) {
    return new IptablesNested(index, item);
  }
  
  public IptablesNested<A> editIptable(int index) {
    if (iptables.size() <= index) throw new RuntimeException("Can't edit iptables. Index exceeds size.");
    return setNewIptableLike(index, buildIptable(index));
  }
  
  public IptablesNested<A> editFirstIptable() {
    if (iptables.size() == 0) throw new RuntimeException("Can't edit first iptables. The list is empty.");
    return setNewIptableLike(0, buildIptable(0));
  }
  
  public IptablesNested<A> editLastIptable() {
    int index = iptables.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last iptables. The list is empty.");
    return setNewIptableLike(index, buildIptable(index));
  }
  
  public IptablesNested<A> editMatchingIptable(Predicate<RawIptablesBuilder> predicate) {
    int index = -1;
    for (int i=0;i<iptables.size();i++) { 
    if (predicate.test(iptables.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching iptables. No match found.");
    return setNewIptableLike(index, buildIptable(index));
  }
  
  public A addToTcs(int index,RawTrafficControl item) {
    if (this.tcs == null) {this.tcs = new ArrayList<RawTrafficControlBuilder>();}
    RawTrafficControlBuilder builder = new RawTrafficControlBuilder(item);
    if (index < 0 || index >= tcs.size()) { _visitables.get("tcs").add(builder); tcs.add(builder); } else { _visitables.get("tcs").add(index, builder); tcs.add(index, builder);}
    return (A)this;
  }
  
  public A setToTcs(int index,RawTrafficControl item) {
    if (this.tcs == null) {this.tcs = new ArrayList<RawTrafficControlBuilder>();}
    RawTrafficControlBuilder builder = new RawTrafficControlBuilder(item);
    if (index < 0 || index >= tcs.size()) { _visitables.get("tcs").add(builder); tcs.add(builder); } else { _visitables.get("tcs").set(index, builder); tcs.set(index, builder);}
    return (A)this;
  }
  
  public A addToTcs(io.fabric8.chaosmesh.v1alpha1.RawTrafficControl... items) {
    if (this.tcs == null) {this.tcs = new ArrayList<RawTrafficControlBuilder>();}
    for (RawTrafficControl item : items) {RawTrafficControlBuilder builder = new RawTrafficControlBuilder(item);_visitables.get("tcs").add(builder);this.tcs.add(builder);} return (A)this;
  }
  
  public A addAllToTcs(Collection<RawTrafficControl> items) {
    if (this.tcs == null) {this.tcs = new ArrayList<RawTrafficControlBuilder>();}
    for (RawTrafficControl item : items) {RawTrafficControlBuilder builder = new RawTrafficControlBuilder(item);_visitables.get("tcs").add(builder);this.tcs.add(builder);} return (A)this;
  }
  
  public A removeFromTcs(io.fabric8.chaosmesh.v1alpha1.RawTrafficControl... items) {
    if (this.tcs == null) return (A)this;
    for (RawTrafficControl item : items) {RawTrafficControlBuilder builder = new RawTrafficControlBuilder(item);_visitables.get("tcs").remove(builder); this.tcs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromTcs(Collection<RawTrafficControl> items) {
    if (this.tcs == null) return (A)this;
    for (RawTrafficControl item : items) {RawTrafficControlBuilder builder = new RawTrafficControlBuilder(item);_visitables.get("tcs").remove(builder); this.tcs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromTcs(Predicate<RawTrafficControlBuilder> predicate) {
    if (tcs == null) return (A) this;
    final Iterator<RawTrafficControlBuilder> each = tcs.iterator();
    final List visitables = _visitables.get("tcs");
    while (each.hasNext()) {
      RawTrafficControlBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<RawTrafficControl> buildTcs() {
    return this.tcs != null ? build(tcs) : null;
  }
  
  public RawTrafficControl buildTc(int index) {
    return this.tcs.get(index).build();
  }
  
  public RawTrafficControl buildFirstTc() {
    return this.tcs.get(0).build();
  }
  
  public RawTrafficControl buildLastTc() {
    return this.tcs.get(tcs.size() - 1).build();
  }
  
  public RawTrafficControl buildMatchingTc(Predicate<RawTrafficControlBuilder> predicate) {
      for (RawTrafficControlBuilder item : tcs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingTc(Predicate<RawTrafficControlBuilder> predicate) {
      for (RawTrafficControlBuilder item : tcs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTcs(List<RawTrafficControl> tcs) {
    if (this.tcs != null) {
      this._visitables.get("tcs").clear();
    }
    if (tcs != null) {
        this.tcs = new ArrayList();
        for (RawTrafficControl item : tcs) {
          this.addToTcs(item);
        }
    } else {
      this.tcs = null;
    }
    return (A) this;
  }
  
  public A withTcs(io.fabric8.chaosmesh.v1alpha1.RawTrafficControl... tcs) {
    if (this.tcs != null) {this.tcs.clear(); _visitables.remove("tcs"); }
    if (tcs != null) {for (RawTrafficControl item :tcs){ this.addToTcs(item);}} return (A) this;
  }
  
  public boolean hasTcs() {
    return this.tcs != null && !this.tcs.isEmpty();
  }
  
  public TcsNested<A> addNewTc() {
    return new TcsNested(-1, null);
  }
  
  public TcsNested<A> addNewTcLike(RawTrafficControl item) {
    return new TcsNested(-1, item);
  }
  
  public TcsNested<A> setNewTcLike(int index,RawTrafficControl item) {
    return new TcsNested(index, item);
  }
  
  public TcsNested<A> editTc(int index) {
    if (tcs.size() <= index) throw new RuntimeException("Can't edit tcs. Index exceeds size.");
    return setNewTcLike(index, buildTc(index));
  }
  
  public TcsNested<A> editFirstTc() {
    if (tcs.size() == 0) throw new RuntimeException("Can't edit first tcs. The list is empty.");
    return setNewTcLike(0, buildTc(0));
  }
  
  public TcsNested<A> editLastTc() {
    int index = tcs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last tcs. The list is empty.");
    return setNewTcLike(index, buildTc(index));
  }
  
  public TcsNested<A> editMatchingTc(Predicate<RawTrafficControlBuilder> predicate) {
    int index = -1;
    for (int i=0;i<tcs.size();i++) { 
    if (predicate.test(tcs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching tcs. No match found.");
    return setNewTcLike(index, buildTc(index));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PodNetworkChaosSpecFluent that = (PodNetworkChaosSpecFluent) o;
    if (!java.util.Objects.equals(ipsets, that.ipsets)) return false;
    if (!java.util.Objects.equals(iptables, that.iptables)) return false;
    if (!java.util.Objects.equals(tcs, that.tcs)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(ipsets,  iptables,  tcs,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ipsets != null && !ipsets.isEmpty()) { sb.append("ipsets:"); sb.append(ipsets + ","); }
    if (iptables != null && !iptables.isEmpty()) { sb.append("iptables:"); sb.append(iptables + ","); }
    if (tcs != null && !tcs.isEmpty()) { sb.append("tcs:"); sb.append(tcs); }
    sb.append("}");
    return sb.toString();
  }
  public class IpsetsNested<N> extends RawIPSetFluent<IpsetsNested<N>> implements Nested<N>{
    IpsetsNested(int index,RawIPSet item) {
      this.index = index;
      this.builder = new RawIPSetBuilder(this, item);
    }
    RawIPSetBuilder builder;
    int index;
    
    public N and() {
      return (N) PodNetworkChaosSpecFluent.this.setToIpsets(index,builder.build());
    }
    
    public N endIpset() {
      return and();
    }
    
  
  }
  public class IptablesNested<N> extends RawIptablesFluent<IptablesNested<N>> implements Nested<N>{
    IptablesNested(int index,RawIptables item) {
      this.index = index;
      this.builder = new RawIptablesBuilder(this, item);
    }
    RawIptablesBuilder builder;
    int index;
    
    public N and() {
      return (N) PodNetworkChaosSpecFluent.this.setToIptables(index,builder.build());
    }
    
    public N endIptable() {
      return and();
    }
    
  
  }
  public class TcsNested<N> extends RawTrafficControlFluent<TcsNested<N>> implements Nested<N>{
    TcsNested(int index,RawTrafficControl item) {
      this.index = index;
      this.builder = new RawTrafficControlBuilder(this, item);
    }
    RawTrafficControlBuilder builder;
    int index;
    
    public N and() {
      return (N) PodNetworkChaosSpecFluent.this.setToTcs(index,builder.build());
    }
    
    public N endTc() {
      return and();
    }
    
  
  }

}