package io.fabric8.chaosmesh.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PodHttpChaosPatchActionsFluent<A extends PodHttpChaosPatchActionsFluent<A>> extends BaseFluent<A>{
  public PodHttpChaosPatchActionsFluent() {
  }
  
  public PodHttpChaosPatchActionsFluent(PodHttpChaosPatchActions instance) {
    this.copyInstance(instance);
  }
  private PodHttpChaosPatchBodyActionBuilder body;
  private List<List<String>> headers = new ArrayList<List<String>>();
  private List<List<String>> queries = new ArrayList<List<String>>();
  
  protected void copyInstance(PodHttpChaosPatchActions instance) {
    instance = (instance != null ? instance : new PodHttpChaosPatchActions());
    if (instance != null) {
          this.withBody(instance.getBody());
          this.withHeaders(instance.getHeaders());
          this.withQueries(instance.getQueries());
          this.withBody(instance.getBody());
          this.withHeaders(instance.getHeaders());
          this.withQueries(instance.getQueries());
        }
  }
  
  public PodHttpChaosPatchBodyAction buildBody() {
    return this.body != null ? this.body.build() : null;
  }
  
  public A withBody(PodHttpChaosPatchBodyAction body) {
    this._visitables.remove(this.body);
    if (body != null) {
        this.body = new PodHttpChaosPatchBodyActionBuilder(body);
        this._visitables.get("body").add(this.body);
    } else {
        this.body = null;
        this._visitables.get("body").remove(this.body);
    }
    return (A) this;
  }
  
  public boolean hasBody() {
    return this.body != null;
  }
  
  public A withNewBody(String type,String value) {
    return (A)withBody(new PodHttpChaosPatchBodyAction(type, value));
  }
  
  public BodyNested<A> withNewBody() {
    return new BodyNested(null);
  }
  
  public BodyNested<A> withNewBodyLike(PodHttpChaosPatchBodyAction item) {
    return new BodyNested(item);
  }
  
  public BodyNested<A> editBody() {
    return withNewBodyLike(java.util.Optional.ofNullable(buildBody()).orElse(null));
  }
  
  public BodyNested<A> editOrNewBody() {
    return withNewBodyLike(java.util.Optional.ofNullable(buildBody()).orElse(new PodHttpChaosPatchBodyActionBuilder().build()));
  }
  
  public BodyNested<A> editOrNewBodyLike(PodHttpChaosPatchBodyAction item) {
    return withNewBodyLike(java.util.Optional.ofNullable(buildBody()).orElse(item));
  }
  
  public A addToHeaders(int index,List<String> item) {
    if (this.headers == null) {this.headers = new ArrayList<List<String>>();}
    this.headers.add(index, item);
    return (A)this;
  }
  
  public A setToHeaders(int index,List<String> item) {
    if (this.headers == null) {this.headers = new ArrayList<List<String>>();}
    this.headers.set(index, item); return (A)this;
  }
  
  public A addToHeaders(List<String>... items) {
    if (this.headers == null) {this.headers = new ArrayList<List<String>>();}
    for (List<String> item : items) {this.headers.add(item);} return (A)this;
  }
  
  public A addAllToHeaders(Collection<List<String>> items) {
    if (this.headers == null) {this.headers = new ArrayList<List<String>>();}
    for (List<String> item : items) {this.headers.add(item);} return (A)this;
  }
  
  public A removeFromHeaders(List<String>... items) {
    if (this.headers == null) return (A)this;
    for (List<String> item : items) { this.headers.remove(item);} return (A)this;
  }
  
  public A removeAllFromHeaders(Collection<List<String>> items) {
    if (this.headers == null) return (A)this;
    for (List<String> item : items) { this.headers.remove(item);} return (A)this;
  }
  
  public List<List<String>> getHeaders() {
    return this.headers;
  }
  
  public List<String> getHeader(int index) {
    return this.headers.get(index);
  }
  
  public List<String> getFirstHeader() {
    return this.headers.get(0);
  }
  
  public List<String> getLastHeader() {
    return this.headers.get(headers.size() - 1);
  }
  
  public List<String> getMatchingHeader(Predicate<List<String>> predicate) {
      for (List<String> item : headers) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingHeader(Predicate<List<String>> predicate) {
      for (List<String> item : headers) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public <E>A withHeaders(List<List<String>> headers) {
    if (headers != null) {
        this.headers = new ArrayList();
        for (List<String> item : headers) {
          this.addToHeaders(item);
        }
    } else {
      this.headers = null;
    }
    return (A) this;
  }
  
  public A withHeaders(List<String>... headers) {
    if (this.headers != null) {this.headers.clear(); _visitables.remove("headers"); }
    if (headers != null) {for (List<String> item :headers){ this.addToHeaders(item);}} return (A) this;
  }
  
  public boolean hasHeaders() {
    return this.headers != null && !this.headers.isEmpty();
  }
  
  public A addToQueries(int index,List<String> item) {
    if (this.queries == null) {this.queries = new ArrayList<List<String>>();}
    this.queries.add(index, item);
    return (A)this;
  }
  
  public A setToQueries(int index,List<String> item) {
    if (this.queries == null) {this.queries = new ArrayList<List<String>>();}
    this.queries.set(index, item); return (A)this;
  }
  
  public A addToQueries(List<String>... items) {
    if (this.queries == null) {this.queries = new ArrayList<List<String>>();}
    for (List<String> item : items) {this.queries.add(item);} return (A)this;
  }
  
  public A addAllToQueries(Collection<List<String>> items) {
    if (this.queries == null) {this.queries = new ArrayList<List<String>>();}
    for (List<String> item : items) {this.queries.add(item);} return (A)this;
  }
  
  public A removeFromQueries(List<String>... items) {
    if (this.queries == null) return (A)this;
    for (List<String> item : items) { this.queries.remove(item);} return (A)this;
  }
  
  public A removeAllFromQueries(Collection<List<String>> items) {
    if (this.queries == null) return (A)this;
    for (List<String> item : items) { this.queries.remove(item);} return (A)this;
  }
  
  public List<List<String>> getQueries() {
    return this.queries;
  }
  
  public List<String> getQuery(int index) {
    return this.queries.get(index);
  }
  
  public List<String> getFirstQuery() {
    return this.queries.get(0);
  }
  
  public List<String> getLastQuery() {
    return this.queries.get(queries.size() - 1);
  }
  
  public List<String> getMatchingQuery(Predicate<List<String>> predicate) {
      for (List<String> item : queries) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingQuery(Predicate<List<String>> predicate) {
      for (List<String> item : queries) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public <E>A withQueries(List<List<String>> queries) {
    if (queries != null) {
        this.queries = new ArrayList();
        for (List<String> item : queries) {
          this.addToQueries(item);
        }
    } else {
      this.queries = null;
    }
    return (A) this;
  }
  
  public A withQueries(List<String>... queries) {
    if (this.queries != null) {this.queries.clear(); _visitables.remove("queries"); }
    if (queries != null) {for (List<String> item :queries){ this.addToQueries(item);}} return (A) this;
  }
  
  public boolean hasQueries() {
    return this.queries != null && !this.queries.isEmpty();
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PodHttpChaosPatchActionsFluent that = (PodHttpChaosPatchActionsFluent) o;
    if (!java.util.Objects.equals(body, that.body)) return false;
    if (!java.util.Objects.equals(headers, that.headers)) return false;
    if (!java.util.Objects.equals(queries, that.queries)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(body,  headers,  queries,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (body != null) { sb.append("body:"); sb.append(body + ","); }
    if (headers != null && !headers.isEmpty()) { sb.append("headers:"); sb.append(headers + ","); }
    if (queries != null && !queries.isEmpty()) { sb.append("queries:"); sb.append(queries); }
    sb.append("}");
    return sb.toString();
  }
  public class BodyNested<N> extends PodHttpChaosPatchBodyActionFluent<BodyNested<N>> implements Nested<N>{
    BodyNested(PodHttpChaosPatchBodyAction item) {
      this.builder = new PodHttpChaosPatchBodyActionBuilder(this, item);
    }
    PodHttpChaosPatchBodyActionBuilder builder;
    
    public N and() {
      return (N) PodHttpChaosPatchActionsFluent.this.withBody(builder.build());
    }
    
    public N endBody() {
      return and();
    }
    
  
  }

}