package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NetworkDNSSpecBuilder extends NetworkDNSSpecFluent<NetworkDNSSpecBuilder> implements VisitableBuilder<NetworkDNSSpec,NetworkDNSSpecBuilder>{
  public NetworkDNSSpecBuilder() {
    this(new NetworkDNSSpec());
  }
  
  public NetworkDNSSpecBuilder(NetworkDNSSpecFluent<?> fluent) {
    this(fluent, new NetworkDNSSpec());
  }
  
  public NetworkDNSSpecBuilder(NetworkDNSSpecFluent<?> fluent,NetworkDNSSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NetworkDNSSpecBuilder(NetworkDNSSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NetworkDNSSpecFluent<?> fluent;
  
  public NetworkDNSSpec build() {
    NetworkDNSSpec buildable = new NetworkDNSSpec(fluent.getDnsDomainName(),fluent.getDnsIp(),fluent.getDnsServer());
    return buildable;
  }
  

}