package io.fabric8.chaosmesh.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class JVMChaosSpecFluent<A extends JVMChaosSpecFluent<A>> extends BaseFluent<A>{
  public JVMChaosSpecFluent() {
  }
  
  public JVMChaosSpecFluent(JVMChaosSpec instance) {
    this.copyInstance(instance);
  }
  private String action;
  private String className;
  private List<String> containerNames = new ArrayList<String>();
  private Integer cpuCount;
  private String duration;
  private String exception;
  private Integer latency;
  private String memType;
  private String method;
  private String mode;
  private String name;
  private Integer port;
  private String ruleData;
  private PodSelectorSpecBuilder selector;
  private String value;
  
  protected void copyInstance(JVMChaosSpec instance) {
    instance = (instance != null ? instance : new JVMChaosSpec());
    if (instance != null) {
          this.withAction(instance.getAction());
          this.withClassName(instance.getClassName());
          this.withContainerNames(instance.getContainerNames());
          this.withCpuCount(instance.getCpuCount());
          this.withDuration(instance.getDuration());
          this.withException(instance.getException());
          this.withLatency(instance.getLatency());
          this.withMemType(instance.getMemType());
          this.withMethod(instance.getMethod());
          this.withMode(instance.getMode());
          this.withName(instance.getName());
          this.withPort(instance.getPort());
          this.withRuleData(instance.getRuleData());
          this.withSelector(instance.getSelector());
          this.withValue(instance.getValue());
          this.withAction(instance.getAction());
          this.withClassName(instance.getClassName());
          this.withContainerNames(instance.getContainerNames());
          this.withCpuCount(instance.getCpuCount());
          this.withDuration(instance.getDuration());
          this.withException(instance.getException());
          this.withLatency(instance.getLatency());
          this.withMemType(instance.getMemType());
          this.withMethod(instance.getMethod());
          this.withMode(instance.getMode());
          this.withName(instance.getName());
          this.withPort(instance.getPort());
          this.withRuleData(instance.getRuleData());
          this.withSelector(instance.getSelector());
          this.withValue(instance.getValue());
        }
  }
  
  public String getAction() {
    return this.action;
  }
  
  public A withAction(String action) {
    this.action = action;
    return (A) this;
  }
  
  public boolean hasAction() {
    return this.action != null;
  }
  
  public String getClassName() {
    return this.className;
  }
  
  public A withClassName(String className) {
    this.className = className;
    return (A) this;
  }
  
  public boolean hasClassName() {
    return this.className != null;
  }
  
  public A addToContainerNames(int index,String item) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    this.containerNames.add(index, item);
    return (A)this;
  }
  
  public A setToContainerNames(int index,String item) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    this.containerNames.set(index, item); return (A)this;
  }
  
  public A addToContainerNames(java.lang.String... items) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    for (String item : items) {this.containerNames.add(item);} return (A)this;
  }
  
  public A addAllToContainerNames(Collection<String> items) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    for (String item : items) {this.containerNames.add(item);} return (A)this;
  }
  
  public A removeFromContainerNames(java.lang.String... items) {
    if (this.containerNames == null) return (A)this;
    for (String item : items) { this.containerNames.remove(item);} return (A)this;
  }
  
  public A removeAllFromContainerNames(Collection<String> items) {
    if (this.containerNames == null) return (A)this;
    for (String item : items) { this.containerNames.remove(item);} return (A)this;
  }
  
  public List<String> getContainerNames() {
    return this.containerNames;
  }
  
  public String getContainerName(int index) {
    return this.containerNames.get(index);
  }
  
  public String getFirstContainerName() {
    return this.containerNames.get(0);
  }
  
  public String getLastContainerName() {
    return this.containerNames.get(containerNames.size() - 1);
  }
  
  public String getMatchingContainerName(Predicate<String> predicate) {
      for (String item : containerNames) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingContainerName(Predicate<String> predicate) {
      for (String item : containerNames) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withContainerNames(List<String> containerNames) {
    if (containerNames != null) {
        this.containerNames = new ArrayList();
        for (String item : containerNames) {
          this.addToContainerNames(item);
        }
    } else {
      this.containerNames = null;
    }
    return (A) this;
  }
  
  public A withContainerNames(java.lang.String... containerNames) {
    if (this.containerNames != null) {this.containerNames.clear(); _visitables.remove("containerNames"); }
    if (containerNames != null) {for (String item :containerNames){ this.addToContainerNames(item);}} return (A) this;
  }
  
  public boolean hasContainerNames() {
    return this.containerNames != null && !this.containerNames.isEmpty();
  }
  
  public Integer getCpuCount() {
    return this.cpuCount;
  }
  
  public A withCpuCount(Integer cpuCount) {
    this.cpuCount = cpuCount;
    return (A) this;
  }
  
  public boolean hasCpuCount() {
    return this.cpuCount != null;
  }
  
  public String getDuration() {
    return this.duration;
  }
  
  public A withDuration(String duration) {
    this.duration = duration;
    return (A) this;
  }
  
  public boolean hasDuration() {
    return this.duration != null;
  }
  
  public String getException() {
    return this.exception;
  }
  
  public A withException(String exception) {
    this.exception = exception;
    return (A) this;
  }
  
  public boolean hasException() {
    return this.exception != null;
  }
  
  public Integer getLatency() {
    return this.latency;
  }
  
  public A withLatency(Integer latency) {
    this.latency = latency;
    return (A) this;
  }
  
  public boolean hasLatency() {
    return this.latency != null;
  }
  
  public String getMemType() {
    return this.memType;
  }
  
  public A withMemType(String memType) {
    this.memType = memType;
    return (A) this;
  }
  
  public boolean hasMemType() {
    return this.memType != null;
  }
  
  public String getMethod() {
    return this.method;
  }
  
  public A withMethod(String method) {
    this.method = method;
    return (A) this;
  }
  
  public boolean hasMethod() {
    return this.method != null;
  }
  
  public String getMode() {
    return this.mode;
  }
  
  public A withMode(String mode) {
    this.mode = mode;
    return (A) this;
  }
  
  public boolean hasMode() {
    return this.mode != null;
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public Integer getPort() {
    return this.port;
  }
  
  public A withPort(Integer port) {
    this.port = port;
    return (A) this;
  }
  
  public boolean hasPort() {
    return this.port != null;
  }
  
  public String getRuleData() {
    return this.ruleData;
  }
  
  public A withRuleData(String ruleData) {
    this.ruleData = ruleData;
    return (A) this;
  }
  
  public boolean hasRuleData() {
    return this.ruleData != null;
  }
  
  public PodSelectorSpec buildSelector() {
    return this.selector != null ? this.selector.build() : null;
  }
  
  public A withSelector(PodSelectorSpec selector) {
    this._visitables.remove(this.selector);
    if (selector != null) {
        this.selector = new PodSelectorSpecBuilder(selector);
        this._visitables.get("selector").add(this.selector);
    } else {
        this.selector = null;
        this._visitables.get("selector").remove(this.selector);
    }
    return (A) this;
  }
  
  public boolean hasSelector() {
    return this.selector != null;
  }
  
  public SelectorNested<A> withNewSelector() {
    return new SelectorNested(null);
  }
  
  public SelectorNested<A> withNewSelectorLike(PodSelectorSpec item) {
    return new SelectorNested(item);
  }
  
  public SelectorNested<A> editSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(null));
  }
  
  public SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(new PodSelectorSpecBuilder().build()));
  }
  
  public SelectorNested<A> editOrNewSelectorLike(PodSelectorSpec item) {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(item));
  }
  
  public String getValue() {
    return this.value;
  }
  
  public A withValue(String value) {
    this.value = value;
    return (A) this;
  }
  
  public boolean hasValue() {
    return this.value != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    JVMChaosSpecFluent that = (JVMChaosSpecFluent) o;
    if (!java.util.Objects.equals(action, that.action)) return false;
    if (!java.util.Objects.equals(className, that.className)) return false;
    if (!java.util.Objects.equals(containerNames, that.containerNames)) return false;
    if (!java.util.Objects.equals(cpuCount, that.cpuCount)) return false;
    if (!java.util.Objects.equals(duration, that.duration)) return false;
    if (!java.util.Objects.equals(exception, that.exception)) return false;
    if (!java.util.Objects.equals(latency, that.latency)) return false;
    if (!java.util.Objects.equals(memType, that.memType)) return false;
    if (!java.util.Objects.equals(method, that.method)) return false;
    if (!java.util.Objects.equals(mode, that.mode)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(port, that.port)) return false;
    if (!java.util.Objects.equals(ruleData, that.ruleData)) return false;
    if (!java.util.Objects.equals(selector, that.selector)) return false;
    if (!java.util.Objects.equals(value, that.value)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(action,  className,  containerNames,  cpuCount,  duration,  exception,  latency,  memType,  method,  mode,  name,  port,  ruleData,  selector,  value,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (action != null) { sb.append("action:"); sb.append(action + ","); }
    if (className != null) { sb.append("className:"); sb.append(className + ","); }
    if (containerNames != null && !containerNames.isEmpty()) { sb.append("containerNames:"); sb.append(containerNames + ","); }
    if (cpuCount != null) { sb.append("cpuCount:"); sb.append(cpuCount + ","); }
    if (duration != null) { sb.append("duration:"); sb.append(duration + ","); }
    if (exception != null) { sb.append("exception:"); sb.append(exception + ","); }
    if (latency != null) { sb.append("latency:"); sb.append(latency + ","); }
    if (memType != null) { sb.append("memType:"); sb.append(memType + ","); }
    if (method != null) { sb.append("method:"); sb.append(method + ","); }
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (ruleData != null) { sb.append("ruleData:"); sb.append(ruleData + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (value != null) { sb.append("value:"); sb.append(value); }
    sb.append("}");
    return sb.toString();
  }
  public class SelectorNested<N> extends PodSelectorSpecFluent<SelectorNested<N>> implements Nested<N>{
    SelectorNested(PodSelectorSpec item) {
      this.builder = new PodSelectorSpecBuilder(this, item);
    }
    PodSelectorSpecBuilder builder;
    
    public N and() {
      return (N) JVMChaosSpecFluent.this.withSelector(builder.build());
    }
    
    public N endSelector() {
      return and();
    }
    
  
  }

}