package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class StressInstanceBuilder extends StressInstanceFluent<StressInstanceBuilder> implements VisitableBuilder<StressInstance,StressInstanceBuilder>{
  public StressInstanceBuilder() {
    this(new StressInstance());
  }
  
  public StressInstanceBuilder(StressInstanceFluent<?> fluent) {
    this(fluent, new StressInstance());
  }
  
  public StressInstanceBuilder(StressInstanceFluent<?> fluent,StressInstance instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public StressInstanceBuilder(StressInstance instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  StressInstanceFluent<?> fluent;
  
  public StressInstance build() {
    StressInstance buildable = new StressInstance(fluent.getMemoryStartTime(),fluent.getMemoryUid(),fluent.getStartTime(),fluent.getUid());
    return buildable;
  }
  

}