package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ProcessSpecBuilder extends ProcessSpecFluent<ProcessSpecBuilder> implements VisitableBuilder<ProcessSpec,ProcessSpecBuilder>{
  public ProcessSpecBuilder() {
    this(new ProcessSpec());
  }
  
  public ProcessSpecBuilder(ProcessSpecFluent<?> fluent) {
    this(fluent, new ProcessSpec());
  }
  
  public ProcessSpecBuilder(ProcessSpecFluent<?> fluent,ProcessSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ProcessSpecBuilder(ProcessSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ProcessSpecFluent<?> fluent;
  
  public ProcessSpec build() {
    ProcessSpec buildable = new ProcessSpec(fluent.getProcess(),fluent.getSignal());
    return buildable;
  }
  

}