package io.fabric8.chaosmesh.v1alpha1;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.function.Predicate;
import java.util.List;
import java.util.Collection;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Integer;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PhysicalMachineChaosSpecFluent<A extends PhysicalMachineChaosSpecFluent<A>> extends BaseFluent<A>{
  public PhysicalMachineChaosSpecFluent() {
  }
  
  public PhysicalMachineChaosSpecFluent(PhysicalMachineChaosSpec instance) {
    this.copyInstance(instance);
  }
  private String action;
  private List<String> address = new ArrayList<String>();
  private ClockSpecBuilder clock;
  private DiskFillSpecBuilder diskFill;
  private DiskPayloadSpecBuilder diskReadPayload;
  private DiskPayloadSpecBuilder diskWritePayload;
  private String duration;
  private JVMExceptionSpecBuilder jvmException;
  private JVMGCSpecBuilder jvmGc;
  private JVMLatencySpecBuilder jvmLatency;
  private JVMReturnSpecBuilder jvmReturn;
  private JVMRuleDataSpecBuilder jvmRuleData;
  private JVMStressSpecBuilder jvmStress;
  private String mode;
  private NetworkBandwidthSpecBuilder networkBandwidth;
  private NetworkCorruptSpecBuilder networkCorrupt;
  private NetworkDelaySpecBuilder networkDelay;
  private NetworkDNSSpecBuilder networkDns;
  private NetworkDuplicateSpecBuilder networkDuplicate;
  private NetworkLossSpecBuilder networkLoss;
  private NetworkPartitionSpecBuilder networkPartition;
  private ProcessSpecBuilder process;
  private PhysicalMachineSelectorSpecBuilder selector;
  private StressCPUSpecBuilder stressCpu;
  private StressMemorySpecBuilder stressMem;
  private String uid;
  private String value;
  
  protected void copyInstance(PhysicalMachineChaosSpec instance) {
    instance = (instance != null ? instance : new PhysicalMachineChaosSpec());
  
    if (instance != null) {
        this.withAction(instance.getAction());
        this.withAddress(instance.getAddress());
        this.withClock(instance.getClock());
        this.withDiskFill(instance.getDiskFill());
        this.withDiskReadPayload(instance.getDiskReadPayload());
        this.withDiskWritePayload(instance.getDiskWritePayload());
        this.withDuration(instance.getDuration());
        this.withJvmException(instance.getJvmException());
        this.withJvmGc(instance.getJvmGc());
        this.withJvmLatency(instance.getJvmLatency());
        this.withJvmReturn(instance.getJvmReturn());
        this.withJvmRuleData(instance.getJvmRuleData());
        this.withJvmStress(instance.getJvmStress());
        this.withMode(instance.getMode());
        this.withNetworkBandwidth(instance.getNetworkBandwidth());
        this.withNetworkCorrupt(instance.getNetworkCorrupt());
        this.withNetworkDelay(instance.getNetworkDelay());
        this.withNetworkDns(instance.getNetworkDns());
        this.withNetworkDuplicate(instance.getNetworkDuplicate());
        this.withNetworkLoss(instance.getNetworkLoss());
        this.withNetworkPartition(instance.getNetworkPartition());
        this.withProcess(instance.getProcess());
        this.withSelector(instance.getSelector());
        this.withStressCpu(instance.getStressCpu());
        this.withStressMem(instance.getStressMem());
        this.withUid(instance.getUid());
        this.withValue(instance.getValue());
        this.withAction(instance.getAction());
        this.withAddress(instance.getAddress());
        this.withClock(instance.getClock());
        this.withDiskFill(instance.getDiskFill());
        this.withDiskReadPayload(instance.getDiskReadPayload());
        this.withDiskWritePayload(instance.getDiskWritePayload());
        this.withDuration(instance.getDuration());
        this.withJvmException(instance.getJvmException());
        this.withJvmGc(instance.getJvmGc());
        this.withJvmLatency(instance.getJvmLatency());
        this.withJvmReturn(instance.getJvmReturn());
        this.withJvmRuleData(instance.getJvmRuleData());
        this.withJvmStress(instance.getJvmStress());
        this.withMode(instance.getMode());
        this.withNetworkBandwidth(instance.getNetworkBandwidth());
        this.withNetworkCorrupt(instance.getNetworkCorrupt());
        this.withNetworkDelay(instance.getNetworkDelay());
        this.withNetworkDns(instance.getNetworkDns());
        this.withNetworkDuplicate(instance.getNetworkDuplicate());
        this.withNetworkLoss(instance.getNetworkLoss());
        this.withNetworkPartition(instance.getNetworkPartition());
        this.withProcess(instance.getProcess());
        this.withSelector(instance.getSelector());
        this.withStressCpu(instance.getStressCpu());
        this.withStressMem(instance.getStressMem());
        this.withUid(instance.getUid());
        this.withValue(instance.getValue());
      }
  }
  
  public String getAction() {
    return this.action;
  }
  
  public A withAction(String action) {
    this.action=action; return (A) this;
  }
  
  public boolean hasAction() {
    return this.action != null;
  }
  
  public A addToAddress(int index,String item) {
    if (this.address == null) {this.address = new ArrayList<String>();}
    this.address.add(index, item);
    return (A)this;
  }
  
  public A setToAddress(int index,String item) {
    if (this.address == null) {this.address = new ArrayList<String>();}
    this.address.set(index, item); return (A)this;
  }
  
  public A addToAddress(java.lang.String... items) {
    if (this.address == null) {this.address = new ArrayList<String>();}
    for (String item : items) {this.address.add(item);} return (A)this;
  }
  
  public A addAllToAddress(Collection<String> items) {
    if (this.address == null) {this.address = new ArrayList<String>();}
    for (String item : items) {this.address.add(item);} return (A)this;
  }
  
  public A removeFromAddress(java.lang.String... items) {
    if (this.address == null) return (A)this;
    for (String item : items) { this.address.remove(item);} return (A)this;
  }
  
  public A removeAllFromAddress(Collection<String> items) {
    if (this.address == null) return (A)this;
    for (String item : items) { this.address.remove(item);} return (A)this;
  }
  
  public List<String> getAddress() {
    return this.address;
  }
  
  public String getAddress(int index) {
    return this.address.get(index);
  }
  
  public String getFirstAddress() {
    return this.address.get(0);
  }
  
  public String getLastAddress() {
    return this.address.get(address.size() - 1);
  }
  
  public String getMatchingAddress(Predicate<String> predicate) {
    for (String item: address) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingAddress(Predicate<String> predicate) {
    for (String item: address) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withAddress(List<String> address) {
    if (address != null) {this.address = new ArrayList(); for (String item : address){this.addToAddress(item);}} else { this.address = null;} return (A) this;
  }
  
  public A withAddress(java.lang.String... address) {
    if (this.address != null) {this.address.clear(); _visitables.remove("address"); }
    if (address != null) {for (String item :address){ this.addToAddress(item);}} return (A) this;
  }
  
  public boolean hasAddress() {
    return address != null && !address.isEmpty();
  }
  
  public ClockSpec buildClock() {
    return this.clock!=null ?this.clock.build():null;
  }
  
  public A withClock(ClockSpec clock) {
    _visitables.get("clock").remove(this.clock);
    if (clock!=null){ this.clock= new ClockSpecBuilder(clock); _visitables.get("clock").add(this.clock);} else { this.clock = null; _visitables.get("clock").remove(this.clock); } return (A) this;
  }
  
  public boolean hasClock() {
    return this.clock != null;
  }
  
  public A withNewClock(String clockIdsSlice,Integer pid,String timeOffset) {
    return (A)withClock(new ClockSpec(clockIdsSlice, pid, timeOffset));
  }
  
  public ClockNested<A> withNewClock() {
    return new ClockNested(null);
  }
  
  public ClockNested<A> withNewClockLike(ClockSpec item) {
    return new ClockNested(item);
  }
  
  public ClockNested<A> editClock() {
    return withNewClockLike(java.util.Optional.ofNullable(buildClock()).orElse(null));
  }
  
  public ClockNested<A> editOrNewClock() {
    return withNewClockLike(java.util.Optional.ofNullable(buildClock()).orElse(new ClockSpecBuilder().build()));
  }
  
  public ClockNested<A> editOrNewClockLike(ClockSpec item) {
    return withNewClockLike(java.util.Optional.ofNullable(buildClock()).orElse(item));
  }
  
  public DiskFillSpec buildDiskFill() {
    return this.diskFill!=null ?this.diskFill.build():null;
  }
  
  public A withDiskFill(DiskFillSpec diskFill) {
    _visitables.get("diskFill").remove(this.diskFill);
    if (diskFill!=null){ this.diskFill= new DiskFillSpecBuilder(diskFill); _visitables.get("diskFill").add(this.diskFill);} else { this.diskFill = null; _visitables.get("diskFill").remove(this.diskFill); } return (A) this;
  }
  
  public boolean hasDiskFill() {
    return this.diskFill != null;
  }
  
  public A withNewDiskFill(Boolean fillByFallocate,String path,String size) {
    return (A)withDiskFill(new DiskFillSpec(fillByFallocate, path, size));
  }
  
  public DiskFillNested<A> withNewDiskFill() {
    return new DiskFillNested(null);
  }
  
  public DiskFillNested<A> withNewDiskFillLike(DiskFillSpec item) {
    return new DiskFillNested(item);
  }
  
  public DiskFillNested<A> editDiskFill() {
    return withNewDiskFillLike(java.util.Optional.ofNullable(buildDiskFill()).orElse(null));
  }
  
  public DiskFillNested<A> editOrNewDiskFill() {
    return withNewDiskFillLike(java.util.Optional.ofNullable(buildDiskFill()).orElse(new DiskFillSpecBuilder().build()));
  }
  
  public DiskFillNested<A> editOrNewDiskFillLike(DiskFillSpec item) {
    return withNewDiskFillLike(java.util.Optional.ofNullable(buildDiskFill()).orElse(item));
  }
  
  public DiskPayloadSpec buildDiskReadPayload() {
    return this.diskReadPayload!=null ?this.diskReadPayload.build():null;
  }
  
  public A withDiskReadPayload(DiskPayloadSpec diskReadPayload) {
    _visitables.get("diskReadPayload").remove(this.diskReadPayload);
    if (diskReadPayload!=null){ this.diskReadPayload= new DiskPayloadSpecBuilder(diskReadPayload); _visitables.get("diskReadPayload").add(this.diskReadPayload);} else { this.diskReadPayload = null; _visitables.get("diskReadPayload").remove(this.diskReadPayload); } return (A) this;
  }
  
  public boolean hasDiskReadPayload() {
    return this.diskReadPayload != null;
  }
  
  public A withNewDiskReadPayload(String path,Integer payloadProcessNum,String size) {
    return (A)withDiskReadPayload(new DiskPayloadSpec(path, payloadProcessNum, size));
  }
  
  public DiskReadPayloadNested<A> withNewDiskReadPayload() {
    return new DiskReadPayloadNested(null);
  }
  
  public DiskReadPayloadNested<A> withNewDiskReadPayloadLike(DiskPayloadSpec item) {
    return new DiskReadPayloadNested(item);
  }
  
  public DiskReadPayloadNested<A> editDiskReadPayload() {
    return withNewDiskReadPayloadLike(java.util.Optional.ofNullable(buildDiskReadPayload()).orElse(null));
  }
  
  public DiskReadPayloadNested<A> editOrNewDiskReadPayload() {
    return withNewDiskReadPayloadLike(java.util.Optional.ofNullable(buildDiskReadPayload()).orElse(new DiskPayloadSpecBuilder().build()));
  }
  
  public DiskReadPayloadNested<A> editOrNewDiskReadPayloadLike(DiskPayloadSpec item) {
    return withNewDiskReadPayloadLike(java.util.Optional.ofNullable(buildDiskReadPayload()).orElse(item));
  }
  
  public DiskPayloadSpec buildDiskWritePayload() {
    return this.diskWritePayload!=null ?this.diskWritePayload.build():null;
  }
  
  public A withDiskWritePayload(DiskPayloadSpec diskWritePayload) {
    _visitables.get("diskWritePayload").remove(this.diskWritePayload);
    if (diskWritePayload!=null){ this.diskWritePayload= new DiskPayloadSpecBuilder(diskWritePayload); _visitables.get("diskWritePayload").add(this.diskWritePayload);} else { this.diskWritePayload = null; _visitables.get("diskWritePayload").remove(this.diskWritePayload); } return (A) this;
  }
  
  public boolean hasDiskWritePayload() {
    return this.diskWritePayload != null;
  }
  
  public A withNewDiskWritePayload(String path,Integer payloadProcessNum,String size) {
    return (A)withDiskWritePayload(new DiskPayloadSpec(path, payloadProcessNum, size));
  }
  
  public DiskWritePayloadNested<A> withNewDiskWritePayload() {
    return new DiskWritePayloadNested(null);
  }
  
  public DiskWritePayloadNested<A> withNewDiskWritePayloadLike(DiskPayloadSpec item) {
    return new DiskWritePayloadNested(item);
  }
  
  public DiskWritePayloadNested<A> editDiskWritePayload() {
    return withNewDiskWritePayloadLike(java.util.Optional.ofNullable(buildDiskWritePayload()).orElse(null));
  }
  
  public DiskWritePayloadNested<A> editOrNewDiskWritePayload() {
    return withNewDiskWritePayloadLike(java.util.Optional.ofNullable(buildDiskWritePayload()).orElse(new DiskPayloadSpecBuilder().build()));
  }
  
  public DiskWritePayloadNested<A> editOrNewDiskWritePayloadLike(DiskPayloadSpec item) {
    return withNewDiskWritePayloadLike(java.util.Optional.ofNullable(buildDiskWritePayload()).orElse(item));
  }
  
  public String getDuration() {
    return this.duration;
  }
  
  public A withDuration(String duration) {
    this.duration=duration; return (A) this;
  }
  
  public boolean hasDuration() {
    return this.duration != null;
  }
  
  public JVMExceptionSpec buildJvmException() {
    return this.jvmException!=null ?this.jvmException.build():null;
  }
  
  public A withJvmException(JVMExceptionSpec jvmException) {
    _visitables.get("jvmException").remove(this.jvmException);
    if (jvmException!=null){ this.jvmException= new JVMExceptionSpecBuilder(jvmException); _visitables.get("jvmException").add(this.jvmException);} else { this.jvmException = null; _visitables.get("jvmException").remove(this.jvmException); } return (A) this;
  }
  
  public boolean hasJvmException() {
    return this.jvmException != null;
  }
  
  public A withNewJvmException(String className,String exception,String method,Integer pid,Integer port) {
    return (A)withJvmException(new JVMExceptionSpec(className, exception, method, pid, port));
  }
  
  public JvmExceptionNested<A> withNewJvmException() {
    return new JvmExceptionNested(null);
  }
  
  public JvmExceptionNested<A> withNewJvmExceptionLike(JVMExceptionSpec item) {
    return new JvmExceptionNested(item);
  }
  
  public JvmExceptionNested<A> editJvmException() {
    return withNewJvmExceptionLike(java.util.Optional.ofNullable(buildJvmException()).orElse(null));
  }
  
  public JvmExceptionNested<A> editOrNewJvmException() {
    return withNewJvmExceptionLike(java.util.Optional.ofNullable(buildJvmException()).orElse(new JVMExceptionSpecBuilder().build()));
  }
  
  public JvmExceptionNested<A> editOrNewJvmExceptionLike(JVMExceptionSpec item) {
    return withNewJvmExceptionLike(java.util.Optional.ofNullable(buildJvmException()).orElse(item));
  }
  
  public JVMGCSpec buildJvmGc() {
    return this.jvmGc!=null ?this.jvmGc.build():null;
  }
  
  public A withJvmGc(JVMGCSpec jvmGc) {
    _visitables.get("jvmGc").remove(this.jvmGc);
    if (jvmGc!=null){ this.jvmGc= new JVMGCSpecBuilder(jvmGc); _visitables.get("jvmGc").add(this.jvmGc);} else { this.jvmGc = null; _visitables.get("jvmGc").remove(this.jvmGc); } return (A) this;
  }
  
  public boolean hasJvmGc() {
    return this.jvmGc != null;
  }
  
  public A withNewJvmGc(Integer pid,Integer port) {
    return (A)withJvmGc(new JVMGCSpec(pid, port));
  }
  
  public JvmGcNested<A> withNewJvmGc() {
    return new JvmGcNested(null);
  }
  
  public JvmGcNested<A> withNewJvmGcLike(JVMGCSpec item) {
    return new JvmGcNested(item);
  }
  
  public JvmGcNested<A> editJvmGc() {
    return withNewJvmGcLike(java.util.Optional.ofNullable(buildJvmGc()).orElse(null));
  }
  
  public JvmGcNested<A> editOrNewJvmGc() {
    return withNewJvmGcLike(java.util.Optional.ofNullable(buildJvmGc()).orElse(new JVMGCSpecBuilder().build()));
  }
  
  public JvmGcNested<A> editOrNewJvmGcLike(JVMGCSpec item) {
    return withNewJvmGcLike(java.util.Optional.ofNullable(buildJvmGc()).orElse(item));
  }
  
  public JVMLatencySpec buildJvmLatency() {
    return this.jvmLatency!=null ?this.jvmLatency.build():null;
  }
  
  public A withJvmLatency(JVMLatencySpec jvmLatency) {
    _visitables.get("jvmLatency").remove(this.jvmLatency);
    if (jvmLatency!=null){ this.jvmLatency= new JVMLatencySpecBuilder(jvmLatency); _visitables.get("jvmLatency").add(this.jvmLatency);} else { this.jvmLatency = null; _visitables.get("jvmLatency").remove(this.jvmLatency); } return (A) this;
  }
  
  public boolean hasJvmLatency() {
    return this.jvmLatency != null;
  }
  
  public A withNewJvmLatency(String className,Integer latency,String method,Integer pid,Integer port) {
    return (A)withJvmLatency(new JVMLatencySpec(className, latency, method, pid, port));
  }
  
  public JvmLatencyNested<A> withNewJvmLatency() {
    return new JvmLatencyNested(null);
  }
  
  public JvmLatencyNested<A> withNewJvmLatencyLike(JVMLatencySpec item) {
    return new JvmLatencyNested(item);
  }
  
  public JvmLatencyNested<A> editJvmLatency() {
    return withNewJvmLatencyLike(java.util.Optional.ofNullable(buildJvmLatency()).orElse(null));
  }
  
  public JvmLatencyNested<A> editOrNewJvmLatency() {
    return withNewJvmLatencyLike(java.util.Optional.ofNullable(buildJvmLatency()).orElse(new JVMLatencySpecBuilder().build()));
  }
  
  public JvmLatencyNested<A> editOrNewJvmLatencyLike(JVMLatencySpec item) {
    return withNewJvmLatencyLike(java.util.Optional.ofNullable(buildJvmLatency()).orElse(item));
  }
  
  public JVMReturnSpec buildJvmReturn() {
    return this.jvmReturn!=null ?this.jvmReturn.build():null;
  }
  
  public A withJvmReturn(JVMReturnSpec jvmReturn) {
    _visitables.get("jvmReturn").remove(this.jvmReturn);
    if (jvmReturn!=null){ this.jvmReturn= new JVMReturnSpecBuilder(jvmReturn); _visitables.get("jvmReturn").add(this.jvmReturn);} else { this.jvmReturn = null; _visitables.get("jvmReturn").remove(this.jvmReturn); } return (A) this;
  }
  
  public boolean hasJvmReturn() {
    return this.jvmReturn != null;
  }
  
  public A withNewJvmReturn(String className,String method,Integer pid,Integer port,String value) {
    return (A)withJvmReturn(new JVMReturnSpec(className, method, pid, port, value));
  }
  
  public JvmReturnNested<A> withNewJvmReturn() {
    return new JvmReturnNested(null);
  }
  
  public JvmReturnNested<A> withNewJvmReturnLike(JVMReturnSpec item) {
    return new JvmReturnNested(item);
  }
  
  public JvmReturnNested<A> editJvmReturn() {
    return withNewJvmReturnLike(java.util.Optional.ofNullable(buildJvmReturn()).orElse(null));
  }
  
  public JvmReturnNested<A> editOrNewJvmReturn() {
    return withNewJvmReturnLike(java.util.Optional.ofNullable(buildJvmReturn()).orElse(new JVMReturnSpecBuilder().build()));
  }
  
  public JvmReturnNested<A> editOrNewJvmReturnLike(JVMReturnSpec item) {
    return withNewJvmReturnLike(java.util.Optional.ofNullable(buildJvmReturn()).orElse(item));
  }
  
  public JVMRuleDataSpec buildJvmRuleData() {
    return this.jvmRuleData!=null ?this.jvmRuleData.build():null;
  }
  
  public A withJvmRuleData(JVMRuleDataSpec jvmRuleData) {
    _visitables.get("jvmRuleData").remove(this.jvmRuleData);
    if (jvmRuleData!=null){ this.jvmRuleData= new JVMRuleDataSpecBuilder(jvmRuleData); _visitables.get("jvmRuleData").add(this.jvmRuleData);} else { this.jvmRuleData = null; _visitables.get("jvmRuleData").remove(this.jvmRuleData); } return (A) this;
  }
  
  public boolean hasJvmRuleData() {
    return this.jvmRuleData != null;
  }
  
  public A withNewJvmRuleData(Integer pid,Integer port,String ruleData) {
    return (A)withJvmRuleData(new JVMRuleDataSpec(pid, port, ruleData));
  }
  
  public JvmRuleDataNested<A> withNewJvmRuleData() {
    return new JvmRuleDataNested(null);
  }
  
  public JvmRuleDataNested<A> withNewJvmRuleDataLike(JVMRuleDataSpec item) {
    return new JvmRuleDataNested(item);
  }
  
  public JvmRuleDataNested<A> editJvmRuleData() {
    return withNewJvmRuleDataLike(java.util.Optional.ofNullable(buildJvmRuleData()).orElse(null));
  }
  
  public JvmRuleDataNested<A> editOrNewJvmRuleData() {
    return withNewJvmRuleDataLike(java.util.Optional.ofNullable(buildJvmRuleData()).orElse(new JVMRuleDataSpecBuilder().build()));
  }
  
  public JvmRuleDataNested<A> editOrNewJvmRuleDataLike(JVMRuleDataSpec item) {
    return withNewJvmRuleDataLike(java.util.Optional.ofNullable(buildJvmRuleData()).orElse(item));
  }
  
  public JVMStressSpec buildJvmStress() {
    return this.jvmStress!=null ?this.jvmStress.build():null;
  }
  
  public A withJvmStress(JVMStressSpec jvmStress) {
    _visitables.get("jvmStress").remove(this.jvmStress);
    if (jvmStress!=null){ this.jvmStress= new JVMStressSpecBuilder(jvmStress); _visitables.get("jvmStress").add(this.jvmStress);} else { this.jvmStress = null; _visitables.get("jvmStress").remove(this.jvmStress); } return (A) this;
  }
  
  public boolean hasJvmStress() {
    return this.jvmStress != null;
  }
  
  public A withNewJvmStress(Integer cpuCount,String memType,Integer pid,Integer port) {
    return (A)withJvmStress(new JVMStressSpec(cpuCount, memType, pid, port));
  }
  
  public JvmStressNested<A> withNewJvmStress() {
    return new JvmStressNested(null);
  }
  
  public JvmStressNested<A> withNewJvmStressLike(JVMStressSpec item) {
    return new JvmStressNested(item);
  }
  
  public JvmStressNested<A> editJvmStress() {
    return withNewJvmStressLike(java.util.Optional.ofNullable(buildJvmStress()).orElse(null));
  }
  
  public JvmStressNested<A> editOrNewJvmStress() {
    return withNewJvmStressLike(java.util.Optional.ofNullable(buildJvmStress()).orElse(new JVMStressSpecBuilder().build()));
  }
  
  public JvmStressNested<A> editOrNewJvmStressLike(JVMStressSpec item) {
    return withNewJvmStressLike(java.util.Optional.ofNullable(buildJvmStress()).orElse(item));
  }
  
  public String getMode() {
    return this.mode;
  }
  
  public A withMode(String mode) {
    this.mode=mode; return (A) this;
  }
  
  public boolean hasMode() {
    return this.mode != null;
  }
  
  public NetworkBandwidthSpec buildNetworkBandwidth() {
    return this.networkBandwidth!=null ?this.networkBandwidth.build():null;
  }
  
  public A withNetworkBandwidth(NetworkBandwidthSpec networkBandwidth) {
    _visitables.get("networkBandwidth").remove(this.networkBandwidth);
    if (networkBandwidth!=null){ this.networkBandwidth= new NetworkBandwidthSpecBuilder(networkBandwidth); _visitables.get("networkBandwidth").add(this.networkBandwidth);} else { this.networkBandwidth = null; _visitables.get("networkBandwidth").remove(this.networkBandwidth); } return (A) this;
  }
  
  public boolean hasNetworkBandwidth() {
    return this.networkBandwidth != null;
  }
  
  public NetworkBandwidthNested<A> withNewNetworkBandwidth() {
    return new NetworkBandwidthNested(null);
  }
  
  public NetworkBandwidthNested<A> withNewNetworkBandwidthLike(NetworkBandwidthSpec item) {
    return new NetworkBandwidthNested(item);
  }
  
  public NetworkBandwidthNested<A> editNetworkBandwidth() {
    return withNewNetworkBandwidthLike(java.util.Optional.ofNullable(buildNetworkBandwidth()).orElse(null));
  }
  
  public NetworkBandwidthNested<A> editOrNewNetworkBandwidth() {
    return withNewNetworkBandwidthLike(java.util.Optional.ofNullable(buildNetworkBandwidth()).orElse(new NetworkBandwidthSpecBuilder().build()));
  }
  
  public NetworkBandwidthNested<A> editOrNewNetworkBandwidthLike(NetworkBandwidthSpec item) {
    return withNewNetworkBandwidthLike(java.util.Optional.ofNullable(buildNetworkBandwidth()).orElse(item));
  }
  
  public NetworkCorruptSpec buildNetworkCorrupt() {
    return this.networkCorrupt!=null ?this.networkCorrupt.build():null;
  }
  
  public A withNetworkCorrupt(NetworkCorruptSpec networkCorrupt) {
    _visitables.get("networkCorrupt").remove(this.networkCorrupt);
    if (networkCorrupt!=null){ this.networkCorrupt= new NetworkCorruptSpecBuilder(networkCorrupt); _visitables.get("networkCorrupt").add(this.networkCorrupt);} else { this.networkCorrupt = null; _visitables.get("networkCorrupt").remove(this.networkCorrupt); } return (A) this;
  }
  
  public boolean hasNetworkCorrupt() {
    return this.networkCorrupt != null;
  }
  
  public NetworkCorruptNested<A> withNewNetworkCorrupt() {
    return new NetworkCorruptNested(null);
  }
  
  public NetworkCorruptNested<A> withNewNetworkCorruptLike(NetworkCorruptSpec item) {
    return new NetworkCorruptNested(item);
  }
  
  public NetworkCorruptNested<A> editNetworkCorrupt() {
    return withNewNetworkCorruptLike(java.util.Optional.ofNullable(buildNetworkCorrupt()).orElse(null));
  }
  
  public NetworkCorruptNested<A> editOrNewNetworkCorrupt() {
    return withNewNetworkCorruptLike(java.util.Optional.ofNullable(buildNetworkCorrupt()).orElse(new NetworkCorruptSpecBuilder().build()));
  }
  
  public NetworkCorruptNested<A> editOrNewNetworkCorruptLike(NetworkCorruptSpec item) {
    return withNewNetworkCorruptLike(java.util.Optional.ofNullable(buildNetworkCorrupt()).orElse(item));
  }
  
  public NetworkDelaySpec buildNetworkDelay() {
    return this.networkDelay!=null ?this.networkDelay.build():null;
  }
  
  public A withNetworkDelay(NetworkDelaySpec networkDelay) {
    _visitables.get("networkDelay").remove(this.networkDelay);
    if (networkDelay!=null){ this.networkDelay= new NetworkDelaySpecBuilder(networkDelay); _visitables.get("networkDelay").add(this.networkDelay);} else { this.networkDelay = null; _visitables.get("networkDelay").remove(this.networkDelay); } return (A) this;
  }
  
  public boolean hasNetworkDelay() {
    return this.networkDelay != null;
  }
  
  public NetworkDelayNested<A> withNewNetworkDelay() {
    return new NetworkDelayNested(null);
  }
  
  public NetworkDelayNested<A> withNewNetworkDelayLike(NetworkDelaySpec item) {
    return new NetworkDelayNested(item);
  }
  
  public NetworkDelayNested<A> editNetworkDelay() {
    return withNewNetworkDelayLike(java.util.Optional.ofNullable(buildNetworkDelay()).orElse(null));
  }
  
  public NetworkDelayNested<A> editOrNewNetworkDelay() {
    return withNewNetworkDelayLike(java.util.Optional.ofNullable(buildNetworkDelay()).orElse(new NetworkDelaySpecBuilder().build()));
  }
  
  public NetworkDelayNested<A> editOrNewNetworkDelayLike(NetworkDelaySpec item) {
    return withNewNetworkDelayLike(java.util.Optional.ofNullable(buildNetworkDelay()).orElse(item));
  }
  
  public NetworkDNSSpec buildNetworkDns() {
    return this.networkDns!=null ?this.networkDns.build():null;
  }
  
  public A withNetworkDns(NetworkDNSSpec networkDns) {
    _visitables.get("networkDns").remove(this.networkDns);
    if (networkDns!=null){ this.networkDns= new NetworkDNSSpecBuilder(networkDns); _visitables.get("networkDns").add(this.networkDns);} else { this.networkDns = null; _visitables.get("networkDns").remove(this.networkDns); } return (A) this;
  }
  
  public boolean hasNetworkDns() {
    return this.networkDns != null;
  }
  
  public A withNewNetworkDns(String dnsDomainName,String dnsIp,String dnsServer) {
    return (A)withNetworkDns(new NetworkDNSSpec(dnsDomainName, dnsIp, dnsServer));
  }
  
  public NetworkDnsNested<A> withNewNetworkDns() {
    return new NetworkDnsNested(null);
  }
  
  public NetworkDnsNested<A> withNewNetworkDnsLike(NetworkDNSSpec item) {
    return new NetworkDnsNested(item);
  }
  
  public NetworkDnsNested<A> editNetworkDns() {
    return withNewNetworkDnsLike(java.util.Optional.ofNullable(buildNetworkDns()).orElse(null));
  }
  
  public NetworkDnsNested<A> editOrNewNetworkDns() {
    return withNewNetworkDnsLike(java.util.Optional.ofNullable(buildNetworkDns()).orElse(new NetworkDNSSpecBuilder().build()));
  }
  
  public NetworkDnsNested<A> editOrNewNetworkDnsLike(NetworkDNSSpec item) {
    return withNewNetworkDnsLike(java.util.Optional.ofNullable(buildNetworkDns()).orElse(item));
  }
  
  public NetworkDuplicateSpec buildNetworkDuplicate() {
    return this.networkDuplicate!=null ?this.networkDuplicate.build():null;
  }
  
  public A withNetworkDuplicate(NetworkDuplicateSpec networkDuplicate) {
    _visitables.get("networkDuplicate").remove(this.networkDuplicate);
    if (networkDuplicate!=null){ this.networkDuplicate= new NetworkDuplicateSpecBuilder(networkDuplicate); _visitables.get("networkDuplicate").add(this.networkDuplicate);} else { this.networkDuplicate = null; _visitables.get("networkDuplicate").remove(this.networkDuplicate); } return (A) this;
  }
  
  public boolean hasNetworkDuplicate() {
    return this.networkDuplicate != null;
  }
  
  public NetworkDuplicateNested<A> withNewNetworkDuplicate() {
    return new NetworkDuplicateNested(null);
  }
  
  public NetworkDuplicateNested<A> withNewNetworkDuplicateLike(NetworkDuplicateSpec item) {
    return new NetworkDuplicateNested(item);
  }
  
  public NetworkDuplicateNested<A> editNetworkDuplicate() {
    return withNewNetworkDuplicateLike(java.util.Optional.ofNullable(buildNetworkDuplicate()).orElse(null));
  }
  
  public NetworkDuplicateNested<A> editOrNewNetworkDuplicate() {
    return withNewNetworkDuplicateLike(java.util.Optional.ofNullable(buildNetworkDuplicate()).orElse(new NetworkDuplicateSpecBuilder().build()));
  }
  
  public NetworkDuplicateNested<A> editOrNewNetworkDuplicateLike(NetworkDuplicateSpec item) {
    return withNewNetworkDuplicateLike(java.util.Optional.ofNullable(buildNetworkDuplicate()).orElse(item));
  }
  
  public NetworkLossSpec buildNetworkLoss() {
    return this.networkLoss!=null ?this.networkLoss.build():null;
  }
  
  public A withNetworkLoss(NetworkLossSpec networkLoss) {
    _visitables.get("networkLoss").remove(this.networkLoss);
    if (networkLoss!=null){ this.networkLoss= new NetworkLossSpecBuilder(networkLoss); _visitables.get("networkLoss").add(this.networkLoss);} else { this.networkLoss = null; _visitables.get("networkLoss").remove(this.networkLoss); } return (A) this;
  }
  
  public boolean hasNetworkLoss() {
    return this.networkLoss != null;
  }
  
  public NetworkLossNested<A> withNewNetworkLoss() {
    return new NetworkLossNested(null);
  }
  
  public NetworkLossNested<A> withNewNetworkLossLike(NetworkLossSpec item) {
    return new NetworkLossNested(item);
  }
  
  public NetworkLossNested<A> editNetworkLoss() {
    return withNewNetworkLossLike(java.util.Optional.ofNullable(buildNetworkLoss()).orElse(null));
  }
  
  public NetworkLossNested<A> editOrNewNetworkLoss() {
    return withNewNetworkLossLike(java.util.Optional.ofNullable(buildNetworkLoss()).orElse(new NetworkLossSpecBuilder().build()));
  }
  
  public NetworkLossNested<A> editOrNewNetworkLossLike(NetworkLossSpec item) {
    return withNewNetworkLossLike(java.util.Optional.ofNullable(buildNetworkLoss()).orElse(item));
  }
  
  public NetworkPartitionSpec buildNetworkPartition() {
    return this.networkPartition!=null ?this.networkPartition.build():null;
  }
  
  public A withNetworkPartition(NetworkPartitionSpec networkPartition) {
    _visitables.get("networkPartition").remove(this.networkPartition);
    if (networkPartition!=null){ this.networkPartition= new NetworkPartitionSpecBuilder(networkPartition); _visitables.get("networkPartition").add(this.networkPartition);} else { this.networkPartition = null; _visitables.get("networkPartition").remove(this.networkPartition); } return (A) this;
  }
  
  public boolean hasNetworkPartition() {
    return this.networkPartition != null;
  }
  
  public NetworkPartitionNested<A> withNewNetworkPartition() {
    return new NetworkPartitionNested(null);
  }
  
  public NetworkPartitionNested<A> withNewNetworkPartitionLike(NetworkPartitionSpec item) {
    return new NetworkPartitionNested(item);
  }
  
  public NetworkPartitionNested<A> editNetworkPartition() {
    return withNewNetworkPartitionLike(java.util.Optional.ofNullable(buildNetworkPartition()).orElse(null));
  }
  
  public NetworkPartitionNested<A> editOrNewNetworkPartition() {
    return withNewNetworkPartitionLike(java.util.Optional.ofNullable(buildNetworkPartition()).orElse(new NetworkPartitionSpecBuilder().build()));
  }
  
  public NetworkPartitionNested<A> editOrNewNetworkPartitionLike(NetworkPartitionSpec item) {
    return withNewNetworkPartitionLike(java.util.Optional.ofNullable(buildNetworkPartition()).orElse(item));
  }
  
  public ProcessSpec buildProcess() {
    return this.process!=null ?this.process.build():null;
  }
  
  public A withProcess(ProcessSpec process) {
    _visitables.get("process").remove(this.process);
    if (process!=null){ this.process= new ProcessSpecBuilder(process); _visitables.get("process").add(this.process);} else { this.process = null; _visitables.get("process").remove(this.process); } return (A) this;
  }
  
  public boolean hasProcess() {
    return this.process != null;
  }
  
  public A withNewProcess(String process,Integer signal) {
    return (A)withProcess(new ProcessSpec(process, signal));
  }
  
  public ProcessNested<A> withNewProcess() {
    return new ProcessNested(null);
  }
  
  public ProcessNested<A> withNewProcessLike(ProcessSpec item) {
    return new ProcessNested(item);
  }
  
  public ProcessNested<A> editProcess() {
    return withNewProcessLike(java.util.Optional.ofNullable(buildProcess()).orElse(null));
  }
  
  public ProcessNested<A> editOrNewProcess() {
    return withNewProcessLike(java.util.Optional.ofNullable(buildProcess()).orElse(new ProcessSpecBuilder().build()));
  }
  
  public ProcessNested<A> editOrNewProcessLike(ProcessSpec item) {
    return withNewProcessLike(java.util.Optional.ofNullable(buildProcess()).orElse(item));
  }
  
  public PhysicalMachineSelectorSpec buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  
  public A withSelector(PhysicalMachineSelectorSpec selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new PhysicalMachineSelectorSpecBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  
  public boolean hasSelector() {
    return this.selector != null;
  }
  
  public SelectorNested<A> withNewSelector() {
    return new SelectorNested(null);
  }
  
  public SelectorNested<A> withNewSelectorLike(PhysicalMachineSelectorSpec item) {
    return new SelectorNested(item);
  }
  
  public SelectorNested<A> editSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(null));
  }
  
  public SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(new PhysicalMachineSelectorSpecBuilder().build()));
  }
  
  public SelectorNested<A> editOrNewSelectorLike(PhysicalMachineSelectorSpec item) {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(item));
  }
  
  public StressCPUSpec buildStressCpu() {
    return this.stressCpu!=null ?this.stressCpu.build():null;
  }
  
  public A withStressCpu(StressCPUSpec stressCpu) {
    _visitables.get("stressCpu").remove(this.stressCpu);
    if (stressCpu!=null){ this.stressCpu= new StressCPUSpecBuilder(stressCpu); _visitables.get("stressCpu").add(this.stressCpu);} else { this.stressCpu = null; _visitables.get("stressCpu").remove(this.stressCpu); } return (A) this;
  }
  
  public boolean hasStressCpu() {
    return this.stressCpu != null;
  }
  
  public A withNewStressCpu(Integer load,String options,Integer workers) {
    return (A)withStressCpu(new StressCPUSpec(load, options, workers));
  }
  
  public StressCpuNested<A> withNewStressCpu() {
    return new StressCpuNested(null);
  }
  
  public StressCpuNested<A> withNewStressCpuLike(StressCPUSpec item) {
    return new StressCpuNested(item);
  }
  
  public StressCpuNested<A> editStressCpu() {
    return withNewStressCpuLike(java.util.Optional.ofNullable(buildStressCpu()).orElse(null));
  }
  
  public StressCpuNested<A> editOrNewStressCpu() {
    return withNewStressCpuLike(java.util.Optional.ofNullable(buildStressCpu()).orElse(new StressCPUSpecBuilder().build()));
  }
  
  public StressCpuNested<A> editOrNewStressCpuLike(StressCPUSpec item) {
    return withNewStressCpuLike(java.util.Optional.ofNullable(buildStressCpu()).orElse(item));
  }
  
  public StressMemorySpec buildStressMem() {
    return this.stressMem!=null ?this.stressMem.build():null;
  }
  
  public A withStressMem(StressMemorySpec stressMem) {
    _visitables.get("stressMem").remove(this.stressMem);
    if (stressMem!=null){ this.stressMem= new StressMemorySpecBuilder(stressMem); _visitables.get("stressMem").add(this.stressMem);} else { this.stressMem = null; _visitables.get("stressMem").remove(this.stressMem); } return (A) this;
  }
  
  public boolean hasStressMem() {
    return this.stressMem != null;
  }
  
  public A withNewStressMem(String options,String size) {
    return (A)withStressMem(new StressMemorySpec(options, size));
  }
  
  public StressMemNested<A> withNewStressMem() {
    return new StressMemNested(null);
  }
  
  public StressMemNested<A> withNewStressMemLike(StressMemorySpec item) {
    return new StressMemNested(item);
  }
  
  public StressMemNested<A> editStressMem() {
    return withNewStressMemLike(java.util.Optional.ofNullable(buildStressMem()).orElse(null));
  }
  
  public StressMemNested<A> editOrNewStressMem() {
    return withNewStressMemLike(java.util.Optional.ofNullable(buildStressMem()).orElse(new StressMemorySpecBuilder().build()));
  }
  
  public StressMemNested<A> editOrNewStressMemLike(StressMemorySpec item) {
    return withNewStressMemLike(java.util.Optional.ofNullable(buildStressMem()).orElse(item));
  }
  
  public String getUid() {
    return this.uid;
  }
  
  public A withUid(String uid) {
    this.uid=uid; return (A) this;
  }
  
  public boolean hasUid() {
    return this.uid != null;
  }
  
  public String getValue() {
    return this.value;
  }
  
  public A withValue(String value) {
    this.value=value; return (A) this;
  }
  
  public boolean hasValue() {
    return this.value != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PhysicalMachineChaosSpecFluent that = (PhysicalMachineChaosSpecFluent) o;
    if (!java.util.Objects.equals(action, that.action)) return false;
  
    if (!java.util.Objects.equals(address, that.address)) return false;
  
    if (!java.util.Objects.equals(clock, that.clock)) return false;
  
    if (!java.util.Objects.equals(diskFill, that.diskFill)) return false;
  
    if (!java.util.Objects.equals(diskReadPayload, that.diskReadPayload)) return false;
  
    if (!java.util.Objects.equals(diskWritePayload, that.diskWritePayload)) return false;
  
    if (!java.util.Objects.equals(duration, that.duration)) return false;
  
    if (!java.util.Objects.equals(jvmException, that.jvmException)) return false;
  
    if (!java.util.Objects.equals(jvmGc, that.jvmGc)) return false;
  
    if (!java.util.Objects.equals(jvmLatency, that.jvmLatency)) return false;
  
    if (!java.util.Objects.equals(jvmReturn, that.jvmReturn)) return false;
  
    if (!java.util.Objects.equals(jvmRuleData, that.jvmRuleData)) return false;
  
    if (!java.util.Objects.equals(jvmStress, that.jvmStress)) return false;
  
    if (!java.util.Objects.equals(mode, that.mode)) return false;
  
    if (!java.util.Objects.equals(networkBandwidth, that.networkBandwidth)) return false;
  
    if (!java.util.Objects.equals(networkCorrupt, that.networkCorrupt)) return false;
  
    if (!java.util.Objects.equals(networkDelay, that.networkDelay)) return false;
  
    if (!java.util.Objects.equals(networkDns, that.networkDns)) return false;
  
    if (!java.util.Objects.equals(networkDuplicate, that.networkDuplicate)) return false;
  
    if (!java.util.Objects.equals(networkLoss, that.networkLoss)) return false;
  
    if (!java.util.Objects.equals(networkPartition, that.networkPartition)) return false;
  
    if (!java.util.Objects.equals(process, that.process)) return false;
  
    if (!java.util.Objects.equals(selector, that.selector)) return false;
  
    if (!java.util.Objects.equals(stressCpu, that.stressCpu)) return false;
  
    if (!java.util.Objects.equals(stressMem, that.stressMem)) return false;
  
    if (!java.util.Objects.equals(uid, that.uid)) return false;
  
    if (!java.util.Objects.equals(value, that.value)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(action,  address,  clock,  diskFill,  diskReadPayload,  diskWritePayload,  duration,  jvmException,  jvmGc,  jvmLatency,  jvmReturn,  jvmRuleData,  jvmStress,  mode,  networkBandwidth,  networkCorrupt,  networkDelay,  networkDns,  networkDuplicate,  networkLoss,  networkPartition,  process,  selector,  stressCpu,  stressMem,  uid,  value,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (action != null) { sb.append("action:"); sb.append(action + ","); }
    if (address != null && !address.isEmpty()) { sb.append("address:"); sb.append(address + ","); }
    if (clock != null) { sb.append("clock:"); sb.append(clock + ","); }
    if (diskFill != null) { sb.append("diskFill:"); sb.append(diskFill + ","); }
    if (diskReadPayload != null) { sb.append("diskReadPayload:"); sb.append(diskReadPayload + ","); }
    if (diskWritePayload != null) { sb.append("diskWritePayload:"); sb.append(diskWritePayload + ","); }
    if (duration != null) { sb.append("duration:"); sb.append(duration + ","); }
    if (jvmException != null) { sb.append("jvmException:"); sb.append(jvmException + ","); }
    if (jvmGc != null) { sb.append("jvmGc:"); sb.append(jvmGc + ","); }
    if (jvmLatency != null) { sb.append("jvmLatency:"); sb.append(jvmLatency + ","); }
    if (jvmReturn != null) { sb.append("jvmReturn:"); sb.append(jvmReturn + ","); }
    if (jvmRuleData != null) { sb.append("jvmRuleData:"); sb.append(jvmRuleData + ","); }
    if (jvmStress != null) { sb.append("jvmStress:"); sb.append(jvmStress + ","); }
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (networkBandwidth != null) { sb.append("networkBandwidth:"); sb.append(networkBandwidth + ","); }
    if (networkCorrupt != null) { sb.append("networkCorrupt:"); sb.append(networkCorrupt + ","); }
    if (networkDelay != null) { sb.append("networkDelay:"); sb.append(networkDelay + ","); }
    if (networkDns != null) { sb.append("networkDns:"); sb.append(networkDns + ","); }
    if (networkDuplicate != null) { sb.append("networkDuplicate:"); sb.append(networkDuplicate + ","); }
    if (networkLoss != null) { sb.append("networkLoss:"); sb.append(networkLoss + ","); }
    if (networkPartition != null) { sb.append("networkPartition:"); sb.append(networkPartition + ","); }
    if (process != null) { sb.append("process:"); sb.append(process + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (stressCpu != null) { sb.append("stressCpu:"); sb.append(stressCpu + ","); }
    if (stressMem != null) { sb.append("stressMem:"); sb.append(stressMem + ","); }
    if (uid != null) { sb.append("uid:"); sb.append(uid + ","); }
    if (value != null) { sb.append("value:"); sb.append(value); }
    sb.append("}");
    return sb.toString();
  }
  public class ClockNested<N> extends ClockSpecFluent<ClockNested<N>> implements Nested<N>{
    ClockNested(ClockSpec item) {
      this.builder = new ClockSpecBuilder(this, item);
    }
    ClockSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withClock(builder.build());
    }
    
    public N endClock() {
      return and();
    }
    
  
  }
  public class DiskFillNested<N> extends DiskFillSpecFluent<DiskFillNested<N>> implements Nested<N>{
    DiskFillNested(DiskFillSpec item) {
      this.builder = new DiskFillSpecBuilder(this, item);
    }
    DiskFillSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withDiskFill(builder.build());
    }
    
    public N endDiskFill() {
      return and();
    }
    
  
  }
  public class DiskReadPayloadNested<N> extends DiskPayloadSpecFluent<DiskReadPayloadNested<N>> implements Nested<N>{
    DiskReadPayloadNested(DiskPayloadSpec item) {
      this.builder = new DiskPayloadSpecBuilder(this, item);
    }
    DiskPayloadSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withDiskReadPayload(builder.build());
    }
    
    public N endDiskReadPayload() {
      return and();
    }
    
  
  }
  public class DiskWritePayloadNested<N> extends DiskPayloadSpecFluent<DiskWritePayloadNested<N>> implements Nested<N>{
    DiskWritePayloadNested(DiskPayloadSpec item) {
      this.builder = new DiskPayloadSpecBuilder(this, item);
    }
    DiskPayloadSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withDiskWritePayload(builder.build());
    }
    
    public N endDiskWritePayload() {
      return and();
    }
    
  
  }
  public class JvmExceptionNested<N> extends JVMExceptionSpecFluent<JvmExceptionNested<N>> implements Nested<N>{
    JvmExceptionNested(JVMExceptionSpec item) {
      this.builder = new JVMExceptionSpecBuilder(this, item);
    }
    JVMExceptionSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withJvmException(builder.build());
    }
    
    public N endJvmException() {
      return and();
    }
    
  
  }
  public class JvmGcNested<N> extends JVMGCSpecFluent<JvmGcNested<N>> implements Nested<N>{
    JvmGcNested(JVMGCSpec item) {
      this.builder = new JVMGCSpecBuilder(this, item);
    }
    JVMGCSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withJvmGc(builder.build());
    }
    
    public N endJvmGc() {
      return and();
    }
    
  
  }
  public class JvmLatencyNested<N> extends JVMLatencySpecFluent<JvmLatencyNested<N>> implements Nested<N>{
    JvmLatencyNested(JVMLatencySpec item) {
      this.builder = new JVMLatencySpecBuilder(this, item);
    }
    JVMLatencySpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withJvmLatency(builder.build());
    }
    
    public N endJvmLatency() {
      return and();
    }
    
  
  }
  public class JvmReturnNested<N> extends JVMReturnSpecFluent<JvmReturnNested<N>> implements Nested<N>{
    JvmReturnNested(JVMReturnSpec item) {
      this.builder = new JVMReturnSpecBuilder(this, item);
    }
    JVMReturnSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withJvmReturn(builder.build());
    }
    
    public N endJvmReturn() {
      return and();
    }
    
  
  }
  public class JvmRuleDataNested<N> extends JVMRuleDataSpecFluent<JvmRuleDataNested<N>> implements Nested<N>{
    JvmRuleDataNested(JVMRuleDataSpec item) {
      this.builder = new JVMRuleDataSpecBuilder(this, item);
    }
    JVMRuleDataSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withJvmRuleData(builder.build());
    }
    
    public N endJvmRuleData() {
      return and();
    }
    
  
  }
  public class JvmStressNested<N> extends JVMStressSpecFluent<JvmStressNested<N>> implements Nested<N>{
    JvmStressNested(JVMStressSpec item) {
      this.builder = new JVMStressSpecBuilder(this, item);
    }
    JVMStressSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withJvmStress(builder.build());
    }
    
    public N endJvmStress() {
      return and();
    }
    
  
  }
  public class NetworkBandwidthNested<N> extends NetworkBandwidthSpecFluent<NetworkBandwidthNested<N>> implements Nested<N>{
    NetworkBandwidthNested(NetworkBandwidthSpec item) {
      this.builder = new NetworkBandwidthSpecBuilder(this, item);
    }
    NetworkBandwidthSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withNetworkBandwidth(builder.build());
    }
    
    public N endNetworkBandwidth() {
      return and();
    }
    
  
  }
  public class NetworkCorruptNested<N> extends NetworkCorruptSpecFluent<NetworkCorruptNested<N>> implements Nested<N>{
    NetworkCorruptNested(NetworkCorruptSpec item) {
      this.builder = new NetworkCorruptSpecBuilder(this, item);
    }
    NetworkCorruptSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withNetworkCorrupt(builder.build());
    }
    
    public N endNetworkCorrupt() {
      return and();
    }
    
  
  }
  public class NetworkDelayNested<N> extends NetworkDelaySpecFluent<NetworkDelayNested<N>> implements Nested<N>{
    NetworkDelayNested(NetworkDelaySpec item) {
      this.builder = new NetworkDelaySpecBuilder(this, item);
    }
    NetworkDelaySpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withNetworkDelay(builder.build());
    }
    
    public N endNetworkDelay() {
      return and();
    }
    
  
  }
  public class NetworkDnsNested<N> extends NetworkDNSSpecFluent<NetworkDnsNested<N>> implements Nested<N>{
    NetworkDnsNested(NetworkDNSSpec item) {
      this.builder = new NetworkDNSSpecBuilder(this, item);
    }
    NetworkDNSSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withNetworkDns(builder.build());
    }
    
    public N endNetworkDns() {
      return and();
    }
    
  
  }
  public class NetworkDuplicateNested<N> extends NetworkDuplicateSpecFluent<NetworkDuplicateNested<N>> implements Nested<N>{
    NetworkDuplicateNested(NetworkDuplicateSpec item) {
      this.builder = new NetworkDuplicateSpecBuilder(this, item);
    }
    NetworkDuplicateSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withNetworkDuplicate(builder.build());
    }
    
    public N endNetworkDuplicate() {
      return and();
    }
    
  
  }
  public class NetworkLossNested<N> extends NetworkLossSpecFluent<NetworkLossNested<N>> implements Nested<N>{
    NetworkLossNested(NetworkLossSpec item) {
      this.builder = new NetworkLossSpecBuilder(this, item);
    }
    NetworkLossSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withNetworkLoss(builder.build());
    }
    
    public N endNetworkLoss() {
      return and();
    }
    
  
  }
  public class NetworkPartitionNested<N> extends NetworkPartitionSpecFluent<NetworkPartitionNested<N>> implements Nested<N>{
    NetworkPartitionNested(NetworkPartitionSpec item) {
      this.builder = new NetworkPartitionSpecBuilder(this, item);
    }
    NetworkPartitionSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withNetworkPartition(builder.build());
    }
    
    public N endNetworkPartition() {
      return and();
    }
    
  
  }
  public class ProcessNested<N> extends ProcessSpecFluent<ProcessNested<N>> implements Nested<N>{
    ProcessNested(ProcessSpec item) {
      this.builder = new ProcessSpecBuilder(this, item);
    }
    ProcessSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withProcess(builder.build());
    }
    
    public N endProcess() {
      return and();
    }
    
  
  }
  public class SelectorNested<N> extends PhysicalMachineSelectorSpecFluent<SelectorNested<N>> implements Nested<N>{
    SelectorNested(PhysicalMachineSelectorSpec item) {
      this.builder = new PhysicalMachineSelectorSpecBuilder(this, item);
    }
    PhysicalMachineSelectorSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withSelector(builder.build());
    }
    
    public N endSelector() {
      return and();
    }
    
  
  }
  public class StressCpuNested<N> extends StressCPUSpecFluent<StressCpuNested<N>> implements Nested<N>{
    StressCpuNested(StressCPUSpec item) {
      this.builder = new StressCPUSpecBuilder(this, item);
    }
    StressCPUSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withStressCpu(builder.build());
    }
    
    public N endStressCpu() {
      return and();
    }
    
  
  }
  public class StressMemNested<N> extends StressMemorySpecFluent<StressMemNested<N>> implements Nested<N>{
    StressMemNested(StressMemorySpec item) {
      this.builder = new StressMemorySpecBuilder(this, item);
    }
    StressMemorySpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withStressMem(builder.build());
    }
    
    public N endStressMem() {
      return and();
    }
    
  
  }

}