package io.fabric8.chaosmesh.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class IOChaosSpecFluent<A extends IOChaosSpecFluent<A>> extends BaseFluent<A>{
  public IOChaosSpecFluent() {
  }
  
  public IOChaosSpecFluent(IOChaosSpec instance) {
    this.copyInstance(instance);
  }
  private String action;
  private AttrOverrideSpecBuilder attr;
  private List<String> containerNames = new ArrayList<String>();
  private String delay;
  private String duration;
  private Integer errno;
  private List<String> methods = new ArrayList<String>();
  private MistakeSpecBuilder mistake;
  private String mode;
  private String path;
  private Integer percent;
  private PodSelectorSpecBuilder selector;
  private String value;
  private String volumePath;
  
  protected void copyInstance(IOChaosSpec instance) {
    instance = (instance != null ? instance : new IOChaosSpec());
  
    if (instance != null) {
        this.withAction(instance.getAction());
        this.withAttr(instance.getAttr());
        this.withContainerNames(instance.getContainerNames());
        this.withDelay(instance.getDelay());
        this.withDuration(instance.getDuration());
        this.withErrno(instance.getErrno());
        this.withMethods(instance.getMethods());
        this.withMistake(instance.getMistake());
        this.withMode(instance.getMode());
        this.withPath(instance.getPath());
        this.withPercent(instance.getPercent());
        this.withSelector(instance.getSelector());
        this.withValue(instance.getValue());
        this.withVolumePath(instance.getVolumePath());
        this.withAction(instance.getAction());
        this.withAttr(instance.getAttr());
        this.withContainerNames(instance.getContainerNames());
        this.withDelay(instance.getDelay());
        this.withDuration(instance.getDuration());
        this.withErrno(instance.getErrno());
        this.withMethods(instance.getMethods());
        this.withMistake(instance.getMistake());
        this.withMode(instance.getMode());
        this.withPath(instance.getPath());
        this.withPercent(instance.getPercent());
        this.withSelector(instance.getSelector());
        this.withValue(instance.getValue());
        this.withVolumePath(instance.getVolumePath());
      }
  }
  
  public String getAction() {
    return this.action;
  }
  
  public A withAction(String action) {
    this.action=action; return (A) this;
  }
  
  public boolean hasAction() {
    return this.action != null;
  }
  
  public AttrOverrideSpec buildAttr() {
    return this.attr!=null ?this.attr.build():null;
  }
  
  public A withAttr(AttrOverrideSpec attr) {
    _visitables.get("attr").remove(this.attr);
    if (attr!=null){ this.attr= new AttrOverrideSpecBuilder(attr); _visitables.get("attr").add(this.attr);} else { this.attr = null; _visitables.get("attr").remove(this.attr); } return (A) this;
  }
  
  public boolean hasAttr() {
    return this.attr != null;
  }
  
  public AttrNested<A> withNewAttr() {
    return new AttrNested(null);
  }
  
  public AttrNested<A> withNewAttrLike(AttrOverrideSpec item) {
    return new AttrNested(item);
  }
  
  public AttrNested<A> editAttr() {
    return withNewAttrLike(java.util.Optional.ofNullable(buildAttr()).orElse(null));
  }
  
  public AttrNested<A> editOrNewAttr() {
    return withNewAttrLike(java.util.Optional.ofNullable(buildAttr()).orElse(new AttrOverrideSpecBuilder().build()));
  }
  
  public AttrNested<A> editOrNewAttrLike(AttrOverrideSpec item) {
    return withNewAttrLike(java.util.Optional.ofNullable(buildAttr()).orElse(item));
  }
  
  public A addToContainerNames(int index,String item) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    this.containerNames.add(index, item);
    return (A)this;
  }
  
  public A setToContainerNames(int index,String item) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    this.containerNames.set(index, item); return (A)this;
  }
  
  public A addToContainerNames(java.lang.String... items) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    for (String item : items) {this.containerNames.add(item);} return (A)this;
  }
  
  public A addAllToContainerNames(Collection<String> items) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    for (String item : items) {this.containerNames.add(item);} return (A)this;
  }
  
  public A removeFromContainerNames(java.lang.String... items) {
    if (this.containerNames == null) return (A)this;
    for (String item : items) { this.containerNames.remove(item);} return (A)this;
  }
  
  public A removeAllFromContainerNames(Collection<String> items) {
    if (this.containerNames == null) return (A)this;
    for (String item : items) { this.containerNames.remove(item);} return (A)this;
  }
  
  public List<String> getContainerNames() {
    return this.containerNames;
  }
  
  public String getContainerName(int index) {
    return this.containerNames.get(index);
  }
  
  public String getFirstContainerName() {
    return this.containerNames.get(0);
  }
  
  public String getLastContainerName() {
    return this.containerNames.get(containerNames.size() - 1);
  }
  
  public String getMatchingContainerName(Predicate<String> predicate) {
    for (String item: containerNames) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingContainerName(Predicate<String> predicate) {
    for (String item: containerNames) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withContainerNames(List<String> containerNames) {
    if (containerNames != null) {this.containerNames = new ArrayList(); for (String item : containerNames){this.addToContainerNames(item);}} else { this.containerNames = null;} return (A) this;
  }
  
  public A withContainerNames(java.lang.String... containerNames) {
    if (this.containerNames != null) {this.containerNames.clear(); _visitables.remove("containerNames"); }
    if (containerNames != null) {for (String item :containerNames){ this.addToContainerNames(item);}} return (A) this;
  }
  
  public boolean hasContainerNames() {
    return containerNames != null && !containerNames.isEmpty();
  }
  
  public String getDelay() {
    return this.delay;
  }
  
  public A withDelay(String delay) {
    this.delay=delay; return (A) this;
  }
  
  public boolean hasDelay() {
    return this.delay != null;
  }
  
  public String getDuration() {
    return this.duration;
  }
  
  public A withDuration(String duration) {
    this.duration=duration; return (A) this;
  }
  
  public boolean hasDuration() {
    return this.duration != null;
  }
  
  public Integer getErrno() {
    return this.errno;
  }
  
  public A withErrno(Integer errno) {
    this.errno=errno; return (A) this;
  }
  
  public boolean hasErrno() {
    return this.errno != null;
  }
  
  public A addToMethods(int index,String item) {
    if (this.methods == null) {this.methods = new ArrayList<String>();}
    this.methods.add(index, item);
    return (A)this;
  }
  
  public A setToMethods(int index,String item) {
    if (this.methods == null) {this.methods = new ArrayList<String>();}
    this.methods.set(index, item); return (A)this;
  }
  
  public A addToMethods(java.lang.String... items) {
    if (this.methods == null) {this.methods = new ArrayList<String>();}
    for (String item : items) {this.methods.add(item);} return (A)this;
  }
  
  public A addAllToMethods(Collection<String> items) {
    if (this.methods == null) {this.methods = new ArrayList<String>();}
    for (String item : items) {this.methods.add(item);} return (A)this;
  }
  
  public A removeFromMethods(java.lang.String... items) {
    if (this.methods == null) return (A)this;
    for (String item : items) { this.methods.remove(item);} return (A)this;
  }
  
  public A removeAllFromMethods(Collection<String> items) {
    if (this.methods == null) return (A)this;
    for (String item : items) { this.methods.remove(item);} return (A)this;
  }
  
  public List<String> getMethods() {
    return this.methods;
  }
  
  public String getMethod(int index) {
    return this.methods.get(index);
  }
  
  public String getFirstMethod() {
    return this.methods.get(0);
  }
  
  public String getLastMethod() {
    return this.methods.get(methods.size() - 1);
  }
  
  public String getMatchingMethod(Predicate<String> predicate) {
    for (String item: methods) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingMethod(Predicate<String> predicate) {
    for (String item: methods) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withMethods(List<String> methods) {
    if (methods != null) {this.methods = new ArrayList(); for (String item : methods){this.addToMethods(item);}} else { this.methods = null;} return (A) this;
  }
  
  public A withMethods(java.lang.String... methods) {
    if (this.methods != null) {this.methods.clear(); _visitables.remove("methods"); }
    if (methods != null) {for (String item :methods){ this.addToMethods(item);}} return (A) this;
  }
  
  public boolean hasMethods() {
    return methods != null && !methods.isEmpty();
  }
  
  public MistakeSpec buildMistake() {
    return this.mistake!=null ?this.mistake.build():null;
  }
  
  public A withMistake(MistakeSpec mistake) {
    _visitables.get("mistake").remove(this.mistake);
    if (mistake!=null){ this.mistake= new MistakeSpecBuilder(mistake); _visitables.get("mistake").add(this.mistake);} else { this.mistake = null; _visitables.get("mistake").remove(this.mistake); } return (A) this;
  }
  
  public boolean hasMistake() {
    return this.mistake != null;
  }
  
  public A withNewMistake(String filling,Long maxLength,Long maxOccurrences) {
    return (A)withMistake(new MistakeSpec(filling, maxLength, maxOccurrences));
  }
  
  public MistakeNested<A> withNewMistake() {
    return new MistakeNested(null);
  }
  
  public MistakeNested<A> withNewMistakeLike(MistakeSpec item) {
    return new MistakeNested(item);
  }
  
  public MistakeNested<A> editMistake() {
    return withNewMistakeLike(java.util.Optional.ofNullable(buildMistake()).orElse(null));
  }
  
  public MistakeNested<A> editOrNewMistake() {
    return withNewMistakeLike(java.util.Optional.ofNullable(buildMistake()).orElse(new MistakeSpecBuilder().build()));
  }
  
  public MistakeNested<A> editOrNewMistakeLike(MistakeSpec item) {
    return withNewMistakeLike(java.util.Optional.ofNullable(buildMistake()).orElse(item));
  }
  
  public String getMode() {
    return this.mode;
  }
  
  public A withMode(String mode) {
    this.mode=mode; return (A) this;
  }
  
  public boolean hasMode() {
    return this.mode != null;
  }
  
  public String getPath() {
    return this.path;
  }
  
  public A withPath(String path) {
    this.path=path; return (A) this;
  }
  
  public boolean hasPath() {
    return this.path != null;
  }
  
  public Integer getPercent() {
    return this.percent;
  }
  
  public A withPercent(Integer percent) {
    this.percent=percent; return (A) this;
  }
  
  public boolean hasPercent() {
    return this.percent != null;
  }
  
  public PodSelectorSpec buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  
  public A withSelector(PodSelectorSpec selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new PodSelectorSpecBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  
  public boolean hasSelector() {
    return this.selector != null;
  }
  
  public SelectorNested<A> withNewSelector() {
    return new SelectorNested(null);
  }
  
  public SelectorNested<A> withNewSelectorLike(PodSelectorSpec item) {
    return new SelectorNested(item);
  }
  
  public SelectorNested<A> editSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(null));
  }
  
  public SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(new PodSelectorSpecBuilder().build()));
  }
  
  public SelectorNested<A> editOrNewSelectorLike(PodSelectorSpec item) {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(item));
  }
  
  public String getValue() {
    return this.value;
  }
  
  public A withValue(String value) {
    this.value=value; return (A) this;
  }
  
  public boolean hasValue() {
    return this.value != null;
  }
  
  public String getVolumePath() {
    return this.volumePath;
  }
  
  public A withVolumePath(String volumePath) {
    this.volumePath=volumePath; return (A) this;
  }
  
  public boolean hasVolumePath() {
    return this.volumePath != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IOChaosSpecFluent that = (IOChaosSpecFluent) o;
    if (!java.util.Objects.equals(action, that.action)) return false;
  
    if (!java.util.Objects.equals(attr, that.attr)) return false;
  
    if (!java.util.Objects.equals(containerNames, that.containerNames)) return false;
  
    if (!java.util.Objects.equals(delay, that.delay)) return false;
  
    if (!java.util.Objects.equals(duration, that.duration)) return false;
  
    if (!java.util.Objects.equals(errno, that.errno)) return false;
  
    if (!java.util.Objects.equals(methods, that.methods)) return false;
  
    if (!java.util.Objects.equals(mistake, that.mistake)) return false;
  
    if (!java.util.Objects.equals(mode, that.mode)) return false;
  
    if (!java.util.Objects.equals(path, that.path)) return false;
  
    if (!java.util.Objects.equals(percent, that.percent)) return false;
  
    if (!java.util.Objects.equals(selector, that.selector)) return false;
  
    if (!java.util.Objects.equals(value, that.value)) return false;
  
    if (!java.util.Objects.equals(volumePath, that.volumePath)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(action,  attr,  containerNames,  delay,  duration,  errno,  methods,  mistake,  mode,  path,  percent,  selector,  value,  volumePath,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (action != null) { sb.append("action:"); sb.append(action + ","); }
    if (attr != null) { sb.append("attr:"); sb.append(attr + ","); }
    if (containerNames != null && !containerNames.isEmpty()) { sb.append("containerNames:"); sb.append(containerNames + ","); }
    if (delay != null) { sb.append("delay:"); sb.append(delay + ","); }
    if (duration != null) { sb.append("duration:"); sb.append(duration + ","); }
    if (errno != null) { sb.append("errno:"); sb.append(errno + ","); }
    if (methods != null && !methods.isEmpty()) { sb.append("methods:"); sb.append(methods + ","); }
    if (mistake != null) { sb.append("mistake:"); sb.append(mistake + ","); }
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (percent != null) { sb.append("percent:"); sb.append(percent + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (value != null) { sb.append("value:"); sb.append(value + ","); }
    if (volumePath != null) { sb.append("volumePath:"); sb.append(volumePath); }
    sb.append("}");
    return sb.toString();
  }
  public class AttrNested<N> extends AttrOverrideSpecFluent<AttrNested<N>> implements Nested<N>{
    AttrNested(AttrOverrideSpec item) {
      this.builder = new AttrOverrideSpecBuilder(this, item);
    }
    AttrOverrideSpecBuilder builder;
    
    public N and() {
      return (N) IOChaosSpecFluent.this.withAttr(builder.build());
    }
    
    public N endAttr() {
      return and();
    }
    
  
  }
  public class MistakeNested<N> extends MistakeSpecFluent<MistakeNested<N>> implements Nested<N>{
    MistakeNested(MistakeSpec item) {
      this.builder = new MistakeSpecBuilder(this, item);
    }
    MistakeSpecBuilder builder;
    
    public N and() {
      return (N) IOChaosSpecFluent.this.withMistake(builder.build());
    }
    
    public N endMistake() {
      return and();
    }
    
  
  }
  public class SelectorNested<N> extends PodSelectorSpecFluent<SelectorNested<N>> implements Nested<N>{
    SelectorNested(PodSelectorSpec item) {
      this.builder = new PodSelectorSpecBuilder(this, item);
    }
    PodSelectorSpecBuilder builder;
    
    public N and() {
      return (N) IOChaosSpecFluent.this.withSelector(builder.build());
    }
    
    public N endSelector() {
      return and();
    }
    
  
  }

}