package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AWSChaosSpecBuilder extends AWSChaosSpecFluent<AWSChaosSpecBuilder> implements VisitableBuilder<AWSChaosSpec,AWSChaosSpecBuilder>{
  public AWSChaosSpecBuilder() {
    this(new AWSChaosSpec());
  }
  
  public AWSChaosSpecBuilder(AWSChaosSpecFluent<?> fluent) {
    this(fluent, new AWSChaosSpec());
  }
  
  public AWSChaosSpecBuilder(AWSChaosSpecFluent<?> fluent,AWSChaosSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AWSChaosSpecBuilder(AWSChaosSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AWSChaosSpecFluent<?> fluent;
  
  public AWSChaosSpec build() {
    AWSChaosSpec buildable = new AWSChaosSpec(fluent.getAction(),fluent.getAwsRegion(),fluent.getDeviceName(),fluent.getDuration(),fluent.getEc2Instance(),fluent.getEndpoint(),fluent.getSecretName(),fluent.getVolumeID());
    return buildable;
  }
  

}