/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.chaosmesh.v1alpha1.MemoryStressor;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class MemoryStressorFluent<A extends MemoryStressorFluent<A>>
extends BaseFluent<A> {
    private List<String> options = new ArrayList<String>();
    private String size;
    private Integer workers;

    public MemoryStressorFluent() {
    }

    public MemoryStressorFluent(MemoryStressor instance) {
        MemoryStressor memoryStressor = instance = instance != null ? instance : new MemoryStressor();
        if (instance != null) {
            this.withOptions(instance.getOptions());
            this.withSize(instance.getSize());
            this.withWorkers(instance.getWorkers());
            this.withOptions(instance.getOptions());
            this.withSize(instance.getSize());
            this.withWorkers(instance.getWorkers());
        }
    }

    public A addToOptions(int index, String item) {
        if (this.options == null) {
            this.options = new ArrayList<String>();
        }
        this.options.add(index, item);
        return (A)((Object)this);
    }

    public A setToOptions(int index, String item) {
        if (this.options == null) {
            this.options = new ArrayList<String>();
        }
        this.options.set(index, item);
        return (A)((Object)this);
    }

    public A addToOptions(String ... items) {
        if (this.options == null) {
            this.options = new ArrayList<String>();
        }
        for (String item : items) {
            this.options.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToOptions(Collection<String> items) {
        if (this.options == null) {
            this.options = new ArrayList<String>();
        }
        for (String item : items) {
            this.options.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromOptions(String ... items) {
        if (this.options == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.options.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromOptions(Collection<String> items) {
        if (this.options == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.options.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getOptions() {
        return this.options;
    }

    public String getOption(int index) {
        return this.options.get(index);
    }

    public String getFirstOption() {
        return this.options.get(0);
    }

    public String getLastOption() {
        return this.options.get(this.options.size() - 1);
    }

    public String getMatchingOption(Predicate<String> predicate) {
        for (String item : this.options) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingOption(Predicate<String> predicate) {
        for (String item : this.options) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withOptions(List<String> options) {
        if (options != null) {
            this.options = new ArrayList<String>();
            for (String item : options) {
                this.addToOptions(item);
            }
        } else {
            this.options = null;
        }
        return (A)((Object)this);
    }

    public A withOptions(String ... options) {
        if (this.options != null) {
            this.options.clear();
            this._visitables.remove((Object)"options");
        }
        if (options != null) {
            for (String item : options) {
                this.addToOptions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasOptions() {
        return this.options != null && !this.options.isEmpty();
    }

    public String getSize() {
        return this.size;
    }

    public A withSize(String size) {
        this.size = size;
        return (A)((Object)this);
    }

    public boolean hasSize() {
        return this.size != null;
    }

    public Integer getWorkers() {
        return this.workers;
    }

    public A withWorkers(Integer workers) {
        this.workers = workers;
        return (A)((Object)this);
    }

    public boolean hasWorkers() {
        return this.workers != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MemoryStressorFluent that = (MemoryStressorFluent)((Object)o);
        if (!Objects.equals(this.options, that.options)) {
            return false;
        }
        if (!Objects.equals(this.size, that.size)) {
            return false;
        }
        return Objects.equals(this.workers, that.workers);
    }

    public int hashCode() {
        return Objects.hash(this.options, this.size, this.workers, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.options != null && !this.options.isEmpty()) {
            sb.append("options:");
            sb.append(this.options + ",");
        }
        if (this.size != null) {
            sb.append("size:");
            sb.append(this.size + ",");
        }
        if (this.workers != null) {
            sb.append("workers:");
            sb.append(this.workers);
        }
        sb.append("}");
        return sb.toString();
    }
}

