package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TimespecBuilder extends TimespecFluent<TimespecBuilder> implements VisitableBuilder<Timespec,TimespecBuilder>{
  public TimespecBuilder() {
    this(false);
  }
  public TimespecBuilder(Boolean validationEnabled) {
    this(new Timespec(), validationEnabled);
  }
  public TimespecBuilder(TimespecFluent<?> fluent) {
    this(fluent, false);
  }
  public TimespecBuilder(TimespecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Timespec(), validationEnabled);
  }
  public TimespecBuilder(TimespecFluent<?> fluent,Timespec instance) {
    this(fluent, instance, false);
  }
  public TimespecBuilder(TimespecFluent<?> fluent,Timespec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Timespec());

    if (instance != null) {
      fluent.withNsec(instance.getNsec());
      fluent.withSec(instance.getSec());
      fluent.withNsec(instance.getNsec());
      fluent.withSec(instance.getSec());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TimespecBuilder(Timespec instance) {
    this(instance,false);
  }
  public TimespecBuilder(Timespec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Timespec());

    if (instance != null) {
      this.withNsec(instance.getNsec());
      this.withSec(instance.getSec());
      this.withNsec(instance.getNsec());
      this.withSec(instance.getSec());
    }
    this.validationEnabled = validationEnabled; 
  }
  TimespecFluent<?> fluent;
  Boolean validationEnabled;
  public Timespec build() {
    Timespec buildable = new Timespec(fluent.getNsec(),fluent.getSec());
    return buildable;
  }
  
}