package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RawIPSetBuilder extends RawIPSetFluent<RawIPSetBuilder> implements VisitableBuilder<RawIPSet,RawIPSetBuilder>{
  public RawIPSetBuilder() {
    this(false);
  }
  public RawIPSetBuilder(Boolean validationEnabled) {
    this(new RawIPSet(), validationEnabled);
  }
  public RawIPSetBuilder(RawIPSetFluent<?> fluent) {
    this(fluent, false);
  }
  public RawIPSetBuilder(RawIPSetFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RawIPSet(), validationEnabled);
  }
  public RawIPSetBuilder(RawIPSetFluent<?> fluent,RawIPSet instance) {
    this(fluent, instance, false);
  }
  public RawIPSetBuilder(RawIPSetFluent<?> fluent,RawIPSet instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new RawIPSet());

    if (instance != null) {
      fluent.withCidrs(instance.getCidrs());
      fluent.withName(instance.getName());
      fluent.withSource(instance.getSource());
      fluent.withCidrs(instance.getCidrs());
      fluent.withName(instance.getName());
      fluent.withSource(instance.getSource());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RawIPSetBuilder(RawIPSet instance) {
    this(instance,false);
  }
  public RawIPSetBuilder(RawIPSet instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new RawIPSet());

    if (instance != null) {
      this.withCidrs(instance.getCidrs());
      this.withName(instance.getName());
      this.withSource(instance.getSource());
      this.withCidrs(instance.getCidrs());
      this.withName(instance.getName());
      this.withSource(instance.getSource());
    }
    this.validationEnabled = validationEnabled; 
  }
  RawIPSetFluent<?> fluent;
  Boolean validationEnabled;
  public RawIPSet build() {
    RawIPSet buildable = new RawIPSet(fluent.getCidrs(),fluent.getName(),fluent.getSource());
    return buildable;
  }
  
}