package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PodIOChaosSpecFluent<A extends PodIOChaosSpecFluent<A>> extends BaseFluent<A>{
  public PodIOChaosSpecFluent() {
  }
  public PodIOChaosSpecFluent(PodIOChaosSpec instance) {
    instance = (instance != null ? instance : new PodIOChaosSpec());

    if (instance != null) {
      this.withActions(instance.getActions());
      this.withContainer(instance.getContainer());
      this.withVolumeMountPath(instance.getVolumeMountPath());
      this.withActions(instance.getActions());
      this.withContainer(instance.getContainer());
      this.withVolumeMountPath(instance.getVolumeMountPath());
    }
  }
  private ArrayList<IOChaosActionBuilder> actions = new ArrayList<IOChaosActionBuilder>();
  private String container;
  private String volumeMountPath;
  public A addToActions(int index,IOChaosAction item) {
    if (this.actions == null) {this.actions = new ArrayList<IOChaosActionBuilder>();}
    IOChaosActionBuilder builder = new IOChaosActionBuilder(item);
    if (index < 0 || index >= actions.size()) { _visitables.get("actions").add(builder); actions.add(builder); } else { _visitables.get("actions").add(index, builder); actions.add(index, builder);}
    return (A)this;
  }
  public A setToActions(int index,IOChaosAction item) {
    if (this.actions == null) {this.actions = new ArrayList<IOChaosActionBuilder>();}
    IOChaosActionBuilder builder = new IOChaosActionBuilder(item);
    if (index < 0 || index >= actions.size()) { _visitables.get("actions").add(builder); actions.add(builder); } else { _visitables.get("actions").set(index, builder); actions.set(index, builder);}
    return (A)this;
  }
  public A addToActions(io.fabric8.chaosmesh.v1alpha1.IOChaosAction... items) {
    if (this.actions == null) {this.actions = new ArrayList<IOChaosActionBuilder>();}
    for (IOChaosAction item : items) {IOChaosActionBuilder builder = new IOChaosActionBuilder(item);_visitables.get("actions").add(builder);this.actions.add(builder);} return (A)this;
  }
  public A addAllToActions(Collection<IOChaosAction> items) {
    if (this.actions == null) {this.actions = new ArrayList<IOChaosActionBuilder>();}
    for (IOChaosAction item : items) {IOChaosActionBuilder builder = new IOChaosActionBuilder(item);_visitables.get("actions").add(builder);this.actions.add(builder);} return (A)this;
  }
  public A removeFromActions(io.fabric8.chaosmesh.v1alpha1.IOChaosAction... items) {
    if (this.actions == null) return (A)this;
    for (IOChaosAction item : items) {IOChaosActionBuilder builder = new IOChaosActionBuilder(item);_visitables.get("actions").remove(builder); this.actions.remove(builder);} return (A)this;
  }
  public A removeAllFromActions(Collection<IOChaosAction> items) {
    if (this.actions == null) return (A)this;
    for (IOChaosAction item : items) {IOChaosActionBuilder builder = new IOChaosActionBuilder(item);_visitables.get("actions").remove(builder); this.actions.remove(builder);} return (A)this;
  }
  public A removeMatchingFromActions(Predicate<IOChaosActionBuilder> predicate) {
    if (actions == null) return (A) this;
    final Iterator<IOChaosActionBuilder> each = actions.iterator();
    final List visitables = _visitables.get("actions");
    while (each.hasNext()) {
      IOChaosActionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<IOChaosAction> buildActions() {
    return actions != null ? build(actions) : null;
  }
  public IOChaosAction buildAction(int index) {
    return this.actions.get(index).build();
  }
  public IOChaosAction buildFirstAction() {
    return this.actions.get(0).build();
  }
  public IOChaosAction buildLastAction() {
    return this.actions.get(actions.size() - 1).build();
  }
  public IOChaosAction buildMatchingAction(Predicate<IOChaosActionBuilder> predicate) {
    for (IOChaosActionBuilder item: actions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingAction(Predicate<IOChaosActionBuilder> predicate) {
    for (IOChaosActionBuilder item: actions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withActions(List<IOChaosAction> actions) {
    if (this.actions != null) { _visitables.get("actions").clear();}
    if (actions != null) {this.actions = new ArrayList(); for (IOChaosAction item : actions){this.addToActions(item);}} else { this.actions = null;} return (A) this;
  }
  public A withActions(io.fabric8.chaosmesh.v1alpha1.IOChaosAction... actions) {
    if (this.actions != null) {this.actions.clear(); _visitables.remove("actions"); }
    if (actions != null) {for (IOChaosAction item :actions){ this.addToActions(item);}} return (A) this;
  }
  public boolean hasActions() {
    return actions != null && !actions.isEmpty();
  }
  public ActionsNested<A> addNewAction() {
    return new ActionsNested(-1, null);
  }
  public ActionsNested<A> addNewActionLike(IOChaosAction item) {
    return new ActionsNested(-1, item);
  }
  public ActionsNested<A> setNewActionLike(int index,IOChaosAction item) {
    return new ActionsNested(index, item);
  }
  public ActionsNested<A> editAction(int index) {
    if (actions.size() <= index) throw new RuntimeException("Can't edit actions. Index exceeds size.");
    return setNewActionLike(index, buildAction(index));
  }
  public ActionsNested<A> editFirstAction() {
    if (actions.size() == 0) throw new RuntimeException("Can't edit first actions. The list is empty.");
    return setNewActionLike(0, buildAction(0));
  }
  public ActionsNested<A> editLastAction() {
    int index = actions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last actions. The list is empty.");
    return setNewActionLike(index, buildAction(index));
  }
  public ActionsNested<A> editMatchingAction(Predicate<IOChaosActionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<actions.size();i++) { 
    if (predicate.test(actions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching actions. No match found.");
    return setNewActionLike(index, buildAction(index));
  }
  public String getContainer() {
    return this.container;
  }
  public A withContainer(String container) {
    this.container=container; return (A) this;
  }
  public boolean hasContainer() {
    return this.container != null;
  }
  public String getVolumeMountPath() {
    return this.volumeMountPath;
  }
  public A withVolumeMountPath(String volumeMountPath) {
    this.volumeMountPath=volumeMountPath; return (A) this;
  }
  public boolean hasVolumeMountPath() {
    return this.volumeMountPath != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PodIOChaosSpecFluent that = (PodIOChaosSpecFluent) o;
    if (!java.util.Objects.equals(actions, that.actions)) return false;

    if (!java.util.Objects.equals(container, that.container)) return false;

    if (!java.util.Objects.equals(volumeMountPath, that.volumeMountPath)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(actions,  container,  volumeMountPath,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (actions != null && !actions.isEmpty()) { sb.append("actions:"); sb.append(actions + ","); }
    if (container != null) { sb.append("container:"); sb.append(container + ","); }
    if (volumeMountPath != null) { sb.append("volumeMountPath:"); sb.append(volumeMountPath); }
    sb.append("}");
    return sb.toString();
  }
  public class ActionsNested<N> extends IOChaosActionFluent<ActionsNested<N>> implements Nested<N>{
    ActionsNested(int index,IOChaosAction item) {
      this.index = index;
      this.builder = new IOChaosActionBuilder(this, item);
    }
    IOChaosActionBuilder builder;
    int index;
    public N and() {
      return (N) PodIOChaosSpecFluent.this.setToActions(index,builder.build());
    }
    public N endAction() {
      return and();
    }
    
  }
  
}