package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodIOChaosListBuilder extends PodIOChaosListFluent<PodIOChaosListBuilder> implements VisitableBuilder<PodIOChaosList,PodIOChaosListBuilder>{
  public PodIOChaosListBuilder() {
    this(false);
  }
  public PodIOChaosListBuilder(Boolean validationEnabled) {
    this(new PodIOChaosList(), validationEnabled);
  }
  public PodIOChaosListBuilder(PodIOChaosListFluent<?> fluent) {
    this(fluent, false);
  }
  public PodIOChaosListBuilder(PodIOChaosListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodIOChaosList(), validationEnabled);
  }
  public PodIOChaosListBuilder(PodIOChaosListFluent<?> fluent,PodIOChaosList instance) {
    this(fluent, instance, false);
  }
  public PodIOChaosListBuilder(PodIOChaosListFluent<?> fluent,PodIOChaosList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodIOChaosList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodIOChaosListBuilder(PodIOChaosList instance) {
    this(instance,false);
  }
  public PodIOChaosListBuilder(PodIOChaosList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodIOChaosList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodIOChaosListFluent<?> fluent;
  Boolean validationEnabled;
  public PodIOChaosList build() {
    PodIOChaosList buildable = new PodIOChaosList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}