package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodChaosBuilder extends PodChaosFluent<PodChaosBuilder> implements VisitableBuilder<PodChaos,PodChaosBuilder>{
  public PodChaosBuilder() {
    this(false);
  }
  public PodChaosBuilder(Boolean validationEnabled) {
    this(new PodChaos(), validationEnabled);
  }
  public PodChaosBuilder(PodChaosFluent<?> fluent) {
    this(fluent, false);
  }
  public PodChaosBuilder(PodChaosFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodChaos(), validationEnabled);
  }
  public PodChaosBuilder(PodChaosFluent<?> fluent,PodChaos instance) {
    this(fluent, instance, false);
  }
  public PodChaosBuilder(PodChaosFluent<?> fluent,PodChaos instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodChaos());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodChaosBuilder(PodChaos instance) {
    this(instance,false);
  }
  public PodChaosBuilder(PodChaos instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodChaos());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodChaosFluent<?> fluent;
  Boolean validationEnabled;
  public PodChaos build() {
    PodChaos buildable = new PodChaos(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}