package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkCorruptSpecBuilder extends NetworkCorruptSpecFluent<NetworkCorruptSpecBuilder> implements VisitableBuilder<NetworkCorruptSpec,NetworkCorruptSpecBuilder>{
  public NetworkCorruptSpecBuilder() {
    this(false);
  }
  public NetworkCorruptSpecBuilder(Boolean validationEnabled) {
    this(new NetworkCorruptSpec(), validationEnabled);
  }
  public NetworkCorruptSpecBuilder(NetworkCorruptSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkCorruptSpecBuilder(NetworkCorruptSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NetworkCorruptSpec(), validationEnabled);
  }
  public NetworkCorruptSpecBuilder(NetworkCorruptSpecFluent<?> fluent,NetworkCorruptSpec instance) {
    this(fluent, instance, false);
  }
  public NetworkCorruptSpecBuilder(NetworkCorruptSpecFluent<?> fluent,NetworkCorruptSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new NetworkCorruptSpec());

    if (instance != null) {
      fluent.withCorrelation(instance.getCorrelation());
      fluent.withDevice(instance.getDevice());
      fluent.withEgressPort(instance.getEgressPort());
      fluent.withHostname(instance.getHostname());
      fluent.withIpAddress(instance.getIpAddress());
      fluent.withIpProtocol(instance.getIpProtocol());
      fluent.withPercent(instance.getPercent());
      fluent.withSourcePort(instance.getSourcePort());
      fluent.withCorrelation(instance.getCorrelation());
      fluent.withDevice(instance.getDevice());
      fluent.withEgressPort(instance.getEgressPort());
      fluent.withHostname(instance.getHostname());
      fluent.withIpAddress(instance.getIpAddress());
      fluent.withIpProtocol(instance.getIpProtocol());
      fluent.withPercent(instance.getPercent());
      fluent.withSourcePort(instance.getSourcePort());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NetworkCorruptSpecBuilder(NetworkCorruptSpec instance) {
    this(instance,false);
  }
  public NetworkCorruptSpecBuilder(NetworkCorruptSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new NetworkCorruptSpec());

    if (instance != null) {
      this.withCorrelation(instance.getCorrelation());
      this.withDevice(instance.getDevice());
      this.withEgressPort(instance.getEgressPort());
      this.withHostname(instance.getHostname());
      this.withIpAddress(instance.getIpAddress());
      this.withIpProtocol(instance.getIpProtocol());
      this.withPercent(instance.getPercent());
      this.withSourcePort(instance.getSourcePort());
      this.withCorrelation(instance.getCorrelation());
      this.withDevice(instance.getDevice());
      this.withEgressPort(instance.getEgressPort());
      this.withHostname(instance.getHostname());
      this.withIpAddress(instance.getIpAddress());
      this.withIpProtocol(instance.getIpProtocol());
      this.withPercent(instance.getPercent());
      this.withSourcePort(instance.getSourcePort());
    }
    this.validationEnabled = validationEnabled; 
  }
  NetworkCorruptSpecFluent<?> fluent;
  Boolean validationEnabled;
  public NetworkCorruptSpec build() {
    NetworkCorruptSpec buildable = new NetworkCorruptSpec(fluent.getCorrelation(),fluent.getDevice(),fluent.getEgressPort(),fluent.getHostname(),fluent.getIpAddress(),fluent.getIpProtocol(),fluent.getPercent(),fluent.getSourcePort());
    return buildable;
  }
  
}