package io.fabric8.chaosmesh.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class NetworkChaosSpecFluent<A extends NetworkChaosSpecFluent<A>> extends BaseFluent<A>{
  public NetworkChaosSpecFluent() {
  }
  public NetworkChaosSpecFluent(NetworkChaosSpec instance) {
    instance = (instance != null ? instance : new NetworkChaosSpec());

    if (instance != null) {
      this.withAction(instance.getAction());
      this.withBandwidth(instance.getBandwidth());
      this.withCorrupt(instance.getCorrupt());
      this.withDelay(instance.getDelay());
      this.withDevice(instance.getDevice());
      this.withDirection(instance.getDirection());
      this.withDuplicate(instance.getDuplicate());
      this.withDuration(instance.getDuration());
      this.withExternalTargets(instance.getExternalTargets());
      this.withLoss(instance.getLoss());
      this.withMode(instance.getMode());
      this.withSelector(instance.getSelector());
      this.withTarget(instance.getTarget());
      this.withTargetDevice(instance.getTargetDevice());
      this.withValue(instance.getValue());
      this.withAction(instance.getAction());
      this.withBandwidth(instance.getBandwidth());
      this.withCorrupt(instance.getCorrupt());
      this.withDelay(instance.getDelay());
      this.withDevice(instance.getDevice());
      this.withDirection(instance.getDirection());
      this.withDuplicate(instance.getDuplicate());
      this.withDuration(instance.getDuration());
      this.withExternalTargets(instance.getExternalTargets());
      this.withLoss(instance.getLoss());
      this.withMode(instance.getMode());
      this.withSelector(instance.getSelector());
      this.withTarget(instance.getTarget());
      this.withTargetDevice(instance.getTargetDevice());
      this.withValue(instance.getValue());
    }
  }
  private String action;
  private BandwidthSpecBuilder bandwidth;
  private CorruptSpecBuilder corrupt;
  private DelaySpecBuilder delay;
  private String device;
  private String direction;
  private DuplicateSpecBuilder duplicate;
  private String duration;
  private List<String> externalTargets = new ArrayList<String>();
  private LossSpecBuilder loss;
  private String mode;
  private PodSelectorSpecBuilder selector;
  private PodSelectorBuilder target;
  private String targetDevice;
  private String value;
  public String getAction() {
    return this.action;
  }
  public A withAction(String action) {
    this.action=action; return (A) this;
  }
  public boolean hasAction() {
    return this.action != null;
  }
  public BandwidthSpec buildBandwidth() {
    return this.bandwidth!=null ?this.bandwidth.build():null;
  }
  public A withBandwidth(BandwidthSpec bandwidth) {
    _visitables.get("bandwidth").remove(this.bandwidth);
    if (bandwidth!=null){ this.bandwidth= new BandwidthSpecBuilder(bandwidth); _visitables.get("bandwidth").add(this.bandwidth);} else { this.bandwidth = null; _visitables.get("bandwidth").remove(this.bandwidth); } return (A) this;
  }
  public boolean hasBandwidth() {
    return this.bandwidth != null;
  }
  public A withNewBandwidth(Integer buffer,Integer limit,Long minburst,Long peakrate,String rate) {
    return (A)withBandwidth(new BandwidthSpec(buffer, limit, minburst, peakrate, rate));
  }
  public BandwidthNested<A> withNewBandwidth() {
    return new BandwidthNested(null);
  }
  public BandwidthNested<A> withNewBandwidthLike(BandwidthSpec item) {
    return new BandwidthNested(item);
  }
  public BandwidthNested<A> editBandwidth() {
    return withNewBandwidthLike(java.util.Optional.ofNullable(buildBandwidth()).orElse(null));
  }
  public BandwidthNested<A> editOrNewBandwidth() {
    return withNewBandwidthLike(java.util.Optional.ofNullable(buildBandwidth()).orElse(new BandwidthSpecBuilder().build()));
  }
  public BandwidthNested<A> editOrNewBandwidthLike(BandwidthSpec item) {
    return withNewBandwidthLike(java.util.Optional.ofNullable(buildBandwidth()).orElse(item));
  }
  public CorruptSpec buildCorrupt() {
    return this.corrupt!=null ?this.corrupt.build():null;
  }
  public A withCorrupt(CorruptSpec corrupt) {
    _visitables.get("corrupt").remove(this.corrupt);
    if (corrupt!=null){ this.corrupt= new CorruptSpecBuilder(corrupt); _visitables.get("corrupt").add(this.corrupt);} else { this.corrupt = null; _visitables.get("corrupt").remove(this.corrupt); } return (A) this;
  }
  public boolean hasCorrupt() {
    return this.corrupt != null;
  }
  public A withNewCorrupt(String correlation,String corrupt) {
    return (A)withCorrupt(new CorruptSpec(correlation, corrupt));
  }
  public CorruptNested<A> withNewCorrupt() {
    return new CorruptNested(null);
  }
  public CorruptNested<A> withNewCorruptLike(CorruptSpec item) {
    return new CorruptNested(item);
  }
  public CorruptNested<A> editCorrupt() {
    return withNewCorruptLike(java.util.Optional.ofNullable(buildCorrupt()).orElse(null));
  }
  public CorruptNested<A> editOrNewCorrupt() {
    return withNewCorruptLike(java.util.Optional.ofNullable(buildCorrupt()).orElse(new CorruptSpecBuilder().build()));
  }
  public CorruptNested<A> editOrNewCorruptLike(CorruptSpec item) {
    return withNewCorruptLike(java.util.Optional.ofNullable(buildCorrupt()).orElse(item));
  }
  public DelaySpec buildDelay() {
    return this.delay!=null ?this.delay.build():null;
  }
  public A withDelay(DelaySpec delay) {
    _visitables.get("delay").remove(this.delay);
    if (delay!=null){ this.delay= new DelaySpecBuilder(delay); _visitables.get("delay").add(this.delay);} else { this.delay = null; _visitables.get("delay").remove(this.delay); } return (A) this;
  }
  public boolean hasDelay() {
    return this.delay != null;
  }
  public DelayNested<A> withNewDelay() {
    return new DelayNested(null);
  }
  public DelayNested<A> withNewDelayLike(DelaySpec item) {
    return new DelayNested(item);
  }
  public DelayNested<A> editDelay() {
    return withNewDelayLike(java.util.Optional.ofNullable(buildDelay()).orElse(null));
  }
  public DelayNested<A> editOrNewDelay() {
    return withNewDelayLike(java.util.Optional.ofNullable(buildDelay()).orElse(new DelaySpecBuilder().build()));
  }
  public DelayNested<A> editOrNewDelayLike(DelaySpec item) {
    return withNewDelayLike(java.util.Optional.ofNullable(buildDelay()).orElse(item));
  }
  public String getDevice() {
    return this.device;
  }
  public A withDevice(String device) {
    this.device=device; return (A) this;
  }
  public boolean hasDevice() {
    return this.device != null;
  }
  public String getDirection() {
    return this.direction;
  }
  public A withDirection(String direction) {
    this.direction=direction; return (A) this;
  }
  public boolean hasDirection() {
    return this.direction != null;
  }
  public DuplicateSpec buildDuplicate() {
    return this.duplicate!=null ?this.duplicate.build():null;
  }
  public A withDuplicate(DuplicateSpec duplicate) {
    _visitables.get("duplicate").remove(this.duplicate);
    if (duplicate!=null){ this.duplicate= new DuplicateSpecBuilder(duplicate); _visitables.get("duplicate").add(this.duplicate);} else { this.duplicate = null; _visitables.get("duplicate").remove(this.duplicate); } return (A) this;
  }
  public boolean hasDuplicate() {
    return this.duplicate != null;
  }
  public A withNewDuplicate(String correlation,String duplicate) {
    return (A)withDuplicate(new DuplicateSpec(correlation, duplicate));
  }
  public DuplicateNested<A> withNewDuplicate() {
    return new DuplicateNested(null);
  }
  public DuplicateNested<A> withNewDuplicateLike(DuplicateSpec item) {
    return new DuplicateNested(item);
  }
  public DuplicateNested<A> editDuplicate() {
    return withNewDuplicateLike(java.util.Optional.ofNullable(buildDuplicate()).orElse(null));
  }
  public DuplicateNested<A> editOrNewDuplicate() {
    return withNewDuplicateLike(java.util.Optional.ofNullable(buildDuplicate()).orElse(new DuplicateSpecBuilder().build()));
  }
  public DuplicateNested<A> editOrNewDuplicateLike(DuplicateSpec item) {
    return withNewDuplicateLike(java.util.Optional.ofNullable(buildDuplicate()).orElse(item));
  }
  public String getDuration() {
    return this.duration;
  }
  public A withDuration(String duration) {
    this.duration=duration; return (A) this;
  }
  public boolean hasDuration() {
    return this.duration != null;
  }
  public A addToExternalTargets(int index,String item) {
    if (this.externalTargets == null) {this.externalTargets = new ArrayList<String>();}
    this.externalTargets.add(index, item);
    return (A)this;
  }
  public A setToExternalTargets(int index,String item) {
    if (this.externalTargets == null) {this.externalTargets = new ArrayList<String>();}
    this.externalTargets.set(index, item); return (A)this;
  }
  public A addToExternalTargets(java.lang.String... items) {
    if (this.externalTargets == null) {this.externalTargets = new ArrayList<String>();}
    for (String item : items) {this.externalTargets.add(item);} return (A)this;
  }
  public A addAllToExternalTargets(Collection<String> items) {
    if (this.externalTargets == null) {this.externalTargets = new ArrayList<String>();}
    for (String item : items) {this.externalTargets.add(item);} return (A)this;
  }
  public A removeFromExternalTargets(java.lang.String... items) {
    if (this.externalTargets == null) return (A)this;
    for (String item : items) { this.externalTargets.remove(item);} return (A)this;
  }
  public A removeAllFromExternalTargets(Collection<String> items) {
    if (this.externalTargets == null) return (A)this;
    for (String item : items) { this.externalTargets.remove(item);} return (A)this;
  }
  public List<String> getExternalTargets() {
    return this.externalTargets;
  }
  public String getExternalTarget(int index) {
    return this.externalTargets.get(index);
  }
  public String getFirstExternalTarget() {
    return this.externalTargets.get(0);
  }
  public String getLastExternalTarget() {
    return this.externalTargets.get(externalTargets.size() - 1);
  }
  public String getMatchingExternalTarget(Predicate<String> predicate) {
    for (String item: externalTargets) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingExternalTarget(Predicate<String> predicate) {
    for (String item: externalTargets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withExternalTargets(List<String> externalTargets) {
    if (externalTargets != null) {this.externalTargets = new ArrayList(); for (String item : externalTargets){this.addToExternalTargets(item);}} else { this.externalTargets = null;} return (A) this;
  }
  public A withExternalTargets(java.lang.String... externalTargets) {
    if (this.externalTargets != null) {this.externalTargets.clear(); _visitables.remove("externalTargets"); }
    if (externalTargets != null) {for (String item :externalTargets){ this.addToExternalTargets(item);}} return (A) this;
  }
  public boolean hasExternalTargets() {
    return externalTargets != null && !externalTargets.isEmpty();
  }
  public LossSpec buildLoss() {
    return this.loss!=null ?this.loss.build():null;
  }
  public A withLoss(LossSpec loss) {
    _visitables.get("loss").remove(this.loss);
    if (loss!=null){ this.loss= new LossSpecBuilder(loss); _visitables.get("loss").add(this.loss);} else { this.loss = null; _visitables.get("loss").remove(this.loss); } return (A) this;
  }
  public boolean hasLoss() {
    return this.loss != null;
  }
  public A withNewLoss(String correlation,String loss) {
    return (A)withLoss(new LossSpec(correlation, loss));
  }
  public LossNested<A> withNewLoss() {
    return new LossNested(null);
  }
  public LossNested<A> withNewLossLike(LossSpec item) {
    return new LossNested(item);
  }
  public LossNested<A> editLoss() {
    return withNewLossLike(java.util.Optional.ofNullable(buildLoss()).orElse(null));
  }
  public LossNested<A> editOrNewLoss() {
    return withNewLossLike(java.util.Optional.ofNullable(buildLoss()).orElse(new LossSpecBuilder().build()));
  }
  public LossNested<A> editOrNewLossLike(LossSpec item) {
    return withNewLossLike(java.util.Optional.ofNullable(buildLoss()).orElse(item));
  }
  public String getMode() {
    return this.mode;
  }
  public A withMode(String mode) {
    this.mode=mode; return (A) this;
  }
  public boolean hasMode() {
    return this.mode != null;
  }
  public PodSelectorSpec buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(PodSelectorSpec selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new PodSelectorSpecBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  public boolean hasSelector() {
    return this.selector != null;
  }
  public SelectorNested<A> withNewSelector() {
    return new SelectorNested(null);
  }
  public SelectorNested<A> withNewSelectorLike(PodSelectorSpec item) {
    return new SelectorNested(item);
  }
  public SelectorNested<A> editSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(null));
  }
  public SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(new PodSelectorSpecBuilder().build()));
  }
  public SelectorNested<A> editOrNewSelectorLike(PodSelectorSpec item) {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(item));
  }
  public PodSelector buildTarget() {
    return this.target!=null ?this.target.build():null;
  }
  public A withTarget(PodSelector target) {
    _visitables.get("target").remove(this.target);
    if (target!=null){ this.target= new PodSelectorBuilder(target); _visitables.get("target").add(this.target);} else { this.target = null; _visitables.get("target").remove(this.target); } return (A) this;
  }
  public boolean hasTarget() {
    return this.target != null;
  }
  public TargetNested<A> withNewTarget() {
    return new TargetNested(null);
  }
  public TargetNested<A> withNewTargetLike(PodSelector item) {
    return new TargetNested(item);
  }
  public TargetNested<A> editTarget() {
    return withNewTargetLike(java.util.Optional.ofNullable(buildTarget()).orElse(null));
  }
  public TargetNested<A> editOrNewTarget() {
    return withNewTargetLike(java.util.Optional.ofNullable(buildTarget()).orElse(new PodSelectorBuilder().build()));
  }
  public TargetNested<A> editOrNewTargetLike(PodSelector item) {
    return withNewTargetLike(java.util.Optional.ofNullable(buildTarget()).orElse(item));
  }
  public String getTargetDevice() {
    return this.targetDevice;
  }
  public A withTargetDevice(String targetDevice) {
    this.targetDevice=targetDevice; return (A) this;
  }
  public boolean hasTargetDevice() {
    return this.targetDevice != null;
  }
  public String getValue() {
    return this.value;
  }
  public A withValue(String value) {
    this.value=value; return (A) this;
  }
  public boolean hasValue() {
    return this.value != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NetworkChaosSpecFluent that = (NetworkChaosSpecFluent) o;
    if (!java.util.Objects.equals(action, that.action)) return false;

    if (!java.util.Objects.equals(bandwidth, that.bandwidth)) return false;

    if (!java.util.Objects.equals(corrupt, that.corrupt)) return false;

    if (!java.util.Objects.equals(delay, that.delay)) return false;

    if (!java.util.Objects.equals(device, that.device)) return false;

    if (!java.util.Objects.equals(direction, that.direction)) return false;

    if (!java.util.Objects.equals(duplicate, that.duplicate)) return false;

    if (!java.util.Objects.equals(duration, that.duration)) return false;

    if (!java.util.Objects.equals(externalTargets, that.externalTargets)) return false;

    if (!java.util.Objects.equals(loss, that.loss)) return false;

    if (!java.util.Objects.equals(mode, that.mode)) return false;

    if (!java.util.Objects.equals(selector, that.selector)) return false;

    if (!java.util.Objects.equals(target, that.target)) return false;

    if (!java.util.Objects.equals(targetDevice, that.targetDevice)) return false;

    if (!java.util.Objects.equals(value, that.value)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(action,  bandwidth,  corrupt,  delay,  device,  direction,  duplicate,  duration,  externalTargets,  loss,  mode,  selector,  target,  targetDevice,  value,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (action != null) { sb.append("action:"); sb.append(action + ","); }
    if (bandwidth != null) { sb.append("bandwidth:"); sb.append(bandwidth + ","); }
    if (corrupt != null) { sb.append("corrupt:"); sb.append(corrupt + ","); }
    if (delay != null) { sb.append("delay:"); sb.append(delay + ","); }
    if (device != null) { sb.append("device:"); sb.append(device + ","); }
    if (direction != null) { sb.append("direction:"); sb.append(direction + ","); }
    if (duplicate != null) { sb.append("duplicate:"); sb.append(duplicate + ","); }
    if (duration != null) { sb.append("duration:"); sb.append(duration + ","); }
    if (externalTargets != null && !externalTargets.isEmpty()) { sb.append("externalTargets:"); sb.append(externalTargets + ","); }
    if (loss != null) { sb.append("loss:"); sb.append(loss + ","); }
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (target != null) { sb.append("target:"); sb.append(target + ","); }
    if (targetDevice != null) { sb.append("targetDevice:"); sb.append(targetDevice + ","); }
    if (value != null) { sb.append("value:"); sb.append(value); }
    sb.append("}");
    return sb.toString();
  }
  public class BandwidthNested<N> extends BandwidthSpecFluent<BandwidthNested<N>> implements Nested<N>{
    BandwidthNested(BandwidthSpec item) {
      this.builder = new BandwidthSpecBuilder(this, item);
    }
    BandwidthSpecBuilder builder;
    public N and() {
      return (N) NetworkChaosSpecFluent.this.withBandwidth(builder.build());
    }
    public N endBandwidth() {
      return and();
    }
    
  }
  public class CorruptNested<N> extends CorruptSpecFluent<CorruptNested<N>> implements Nested<N>{
    CorruptNested(CorruptSpec item) {
      this.builder = new CorruptSpecBuilder(this, item);
    }
    CorruptSpecBuilder builder;
    public N and() {
      return (N) NetworkChaosSpecFluent.this.withCorrupt(builder.build());
    }
    public N endCorrupt() {
      return and();
    }
    
  }
  public class DelayNested<N> extends DelaySpecFluent<DelayNested<N>> implements Nested<N>{
    DelayNested(DelaySpec item) {
      this.builder = new DelaySpecBuilder(this, item);
    }
    DelaySpecBuilder builder;
    public N and() {
      return (N) NetworkChaosSpecFluent.this.withDelay(builder.build());
    }
    public N endDelay() {
      return and();
    }
    
  }
  public class DuplicateNested<N> extends DuplicateSpecFluent<DuplicateNested<N>> implements Nested<N>{
    DuplicateNested(DuplicateSpec item) {
      this.builder = new DuplicateSpecBuilder(this, item);
    }
    DuplicateSpecBuilder builder;
    public N and() {
      return (N) NetworkChaosSpecFluent.this.withDuplicate(builder.build());
    }
    public N endDuplicate() {
      return and();
    }
    
  }
  public class LossNested<N> extends LossSpecFluent<LossNested<N>> implements Nested<N>{
    LossNested(LossSpec item) {
      this.builder = new LossSpecBuilder(this, item);
    }
    LossSpecBuilder builder;
    public N and() {
      return (N) NetworkChaosSpecFluent.this.withLoss(builder.build());
    }
    public N endLoss() {
      return and();
    }
    
  }
  public class SelectorNested<N> extends PodSelectorSpecFluent<SelectorNested<N>> implements Nested<N>{
    SelectorNested(PodSelectorSpec item) {
      this.builder = new PodSelectorSpecBuilder(this, item);
    }
    PodSelectorSpecBuilder builder;
    public N and() {
      return (N) NetworkChaosSpecFluent.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  public class TargetNested<N> extends PodSelectorFluent<TargetNested<N>> implements Nested<N>{
    TargetNested(PodSelector item) {
      this.builder = new PodSelectorBuilder(this, item);
    }
    PodSelectorBuilder builder;
    public N and() {
      return (N) NetworkChaosSpecFluent.this.withTarget(builder.build());
    }
    public N endTarget() {
      return and();
    }
    
  }
  
}