package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkChaosBuilder extends NetworkChaosFluent<NetworkChaosBuilder> implements VisitableBuilder<NetworkChaos,NetworkChaosBuilder>{
  public NetworkChaosBuilder() {
    this(false);
  }
  public NetworkChaosBuilder(Boolean validationEnabled) {
    this(new NetworkChaos(), validationEnabled);
  }
  public NetworkChaosBuilder(NetworkChaosFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkChaosBuilder(NetworkChaosFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NetworkChaos(), validationEnabled);
  }
  public NetworkChaosBuilder(NetworkChaosFluent<?> fluent,NetworkChaos instance) {
    this(fluent, instance, false);
  }
  public NetworkChaosBuilder(NetworkChaosFluent<?> fluent,NetworkChaos instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new NetworkChaos());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NetworkChaosBuilder(NetworkChaos instance) {
    this(instance,false);
  }
  public NetworkChaosBuilder(NetworkChaos instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new NetworkChaos());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  NetworkChaosFluent<?> fluent;
  Boolean validationEnabled;
  public NetworkChaos build() {
    NetworkChaos buildable = new NetworkChaos(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}