package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KernelChaosSpecBuilder extends KernelChaosSpecFluent<KernelChaosSpecBuilder> implements VisitableBuilder<KernelChaosSpec,KernelChaosSpecBuilder>{
  public KernelChaosSpecBuilder() {
    this(false);
  }
  public KernelChaosSpecBuilder(Boolean validationEnabled) {
    this(new KernelChaosSpec(), validationEnabled);
  }
  public KernelChaosSpecBuilder(KernelChaosSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KernelChaosSpecBuilder(KernelChaosSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KernelChaosSpec(), validationEnabled);
  }
  public KernelChaosSpecBuilder(KernelChaosSpecFluent<?> fluent,KernelChaosSpec instance) {
    this(fluent, instance, false);
  }
  public KernelChaosSpecBuilder(KernelChaosSpecFluent<?> fluent,KernelChaosSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KernelChaosSpec());

    if (instance != null) {
      fluent.withDuration(instance.getDuration());
      fluent.withFailKernRequest(instance.getFailKernRequest());
      fluent.withMode(instance.getMode());
      fluent.withSelector(instance.getSelector());
      fluent.withValue(instance.getValue());
      fluent.withDuration(instance.getDuration());
      fluent.withFailKernRequest(instance.getFailKernRequest());
      fluent.withMode(instance.getMode());
      fluent.withSelector(instance.getSelector());
      fluent.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KernelChaosSpecBuilder(KernelChaosSpec instance) {
    this(instance,false);
  }
  public KernelChaosSpecBuilder(KernelChaosSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KernelChaosSpec());

    if (instance != null) {
      this.withDuration(instance.getDuration());
      this.withFailKernRequest(instance.getFailKernRequest());
      this.withMode(instance.getMode());
      this.withSelector(instance.getSelector());
      this.withValue(instance.getValue());
      this.withDuration(instance.getDuration());
      this.withFailKernRequest(instance.getFailKernRequest());
      this.withMode(instance.getMode());
      this.withSelector(instance.getSelector());
      this.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  KernelChaosSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KernelChaosSpec build() {
    KernelChaosSpec buildable = new KernelChaosSpec(fluent.getDuration(),fluent.buildFailKernRequest(),fluent.getMode(),fluent.buildSelector(),fluent.getValue());
    return buildable;
  }
  
}