package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class JVMChaosStatusFluent<A extends JVMChaosStatusFluent<A>> extends BaseFluent<A>{
  public JVMChaosStatusFluent() {
  }
  public JVMChaosStatusFluent(JVMChaosStatus instance) {
    instance = (instance != null ? instance : new JVMChaosStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withExperiment(instance.getExperiment());
      this.withConditions(instance.getConditions());
      this.withExperiment(instance.getExperiment());
    }
  }
  private ArrayList<ChaosConditionBuilder> conditions = new ArrayList<ChaosConditionBuilder>();
  private ExperimentStatusBuilder experiment;
  public A addToConditions(int index,ChaosCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ChaosConditionBuilder>();}
    ChaosConditionBuilder builder = new ChaosConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  public A setToConditions(int index,ChaosCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ChaosConditionBuilder>();}
    ChaosConditionBuilder builder = new ChaosConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  public A addToConditions(io.fabric8.chaosmesh.v1alpha1.ChaosCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ChaosConditionBuilder>();}
    for (ChaosCondition item : items) {ChaosConditionBuilder builder = new ChaosConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<ChaosCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ChaosConditionBuilder>();}
    for (ChaosCondition item : items) {ChaosConditionBuilder builder = new ChaosConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.chaosmesh.v1alpha1.ChaosCondition... items) {
    if (this.conditions == null) return (A)this;
    for (ChaosCondition item : items) {ChaosConditionBuilder builder = new ChaosConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  public A removeAllFromConditions(Collection<ChaosCondition> items) {
    if (this.conditions == null) return (A)this;
    for (ChaosCondition item : items) {ChaosConditionBuilder builder = new ChaosConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<ChaosConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ChaosConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ChaosConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<ChaosCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public ChaosCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  public ChaosCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public ChaosCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public ChaosCondition buildMatchingCondition(Predicate<ChaosConditionBuilder> predicate) {
    for (ChaosConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingCondition(Predicate<ChaosConditionBuilder> predicate) {
    for (ChaosConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<ChaosCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (ChaosCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.chaosmesh.v1alpha1.ChaosCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (ChaosCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(String reason,String status,String type) {
    return (A)addToConditions(new ChaosCondition(reason, status, type));
  }
  public ConditionsNested<A> addNewCondition() {
    return new ConditionsNested(-1, null);
  }
  public ConditionsNested<A> addNewConditionLike(ChaosCondition item) {
    return new ConditionsNested(-1, item);
  }
  public ConditionsNested<A> setNewConditionLike(int index,ChaosCondition item) {
    return new ConditionsNested(index, item);
  }
  public ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ConditionsNested<A> editMatchingCondition(Predicate<ChaosConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ExperimentStatus buildExperiment() {
    return this.experiment!=null ?this.experiment.build():null;
  }
  public A withExperiment(ExperimentStatus experiment) {
    _visitables.get("experiment").remove(this.experiment);
    if (experiment!=null){ this.experiment= new ExperimentStatusBuilder(experiment); _visitables.get("experiment").add(this.experiment);} else { this.experiment = null; _visitables.get("experiment").remove(this.experiment); } return (A) this;
  }
  public boolean hasExperiment() {
    return this.experiment != null;
  }
  public ExperimentNested<A> withNewExperiment() {
    return new ExperimentNested(null);
  }
  public ExperimentNested<A> withNewExperimentLike(ExperimentStatus item) {
    return new ExperimentNested(item);
  }
  public ExperimentNested<A> editExperiment() {
    return withNewExperimentLike(java.util.Optional.ofNullable(buildExperiment()).orElse(null));
  }
  public ExperimentNested<A> editOrNewExperiment() {
    return withNewExperimentLike(java.util.Optional.ofNullable(buildExperiment()).orElse(new ExperimentStatusBuilder().build()));
  }
  public ExperimentNested<A> editOrNewExperimentLike(ExperimentStatus item) {
    return withNewExperimentLike(java.util.Optional.ofNullable(buildExperiment()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    JVMChaosStatusFluent that = (JVMChaosStatusFluent) o;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(experiment, that.experiment)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  experiment,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (experiment != null) { sb.append("experiment:"); sb.append(experiment); }
    sb.append("}");
    return sb.toString();
  }
  public class ConditionsNested<N> extends ChaosConditionFluent<ConditionsNested<N>> implements Nested<N>{
    ConditionsNested(int index,ChaosCondition item) {
      this.index = index;
      this.builder = new ChaosConditionBuilder(this, item);
    }
    ChaosConditionBuilder builder;
    int index;
    public N and() {
      return (N) JVMChaosStatusFluent.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  public class ExperimentNested<N> extends ExperimentStatusFluent<ExperimentNested<N>> implements Nested<N>{
    ExperimentNested(ExperimentStatus item) {
      this.builder = new ExperimentStatusBuilder(this, item);
    }
    ExperimentStatusBuilder builder;
    public N and() {
      return (N) JVMChaosStatusFluent.this.withExperiment(builder.build());
    }
    public N endExperiment() {
      return and();
    }
    
  }
  
}