package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IOChaosActionFluent<A extends IOChaosActionFluent<A>> extends BaseFluent<A>{
  public IOChaosActionFluent() {
  }
  public IOChaosActionFluent(IOChaosAction instance) {
    instance = (instance != null ? instance : new IOChaosAction());

    if (instance != null) {
      this.withAtime(instance.getAtime());
      this.withBlocks(instance.getBlocks());
      this.withCtime(instance.getCtime());
      this.withFaults(instance.getFaults());
      this.withGid(instance.getGid());
      this.withIno(instance.getIno());
      this.withKind(instance.getKind());
      this.withLatency(instance.getLatency());
      this.withMethods(instance.getMethods());
      this.withMistake(instance.getMistake());
      this.withMtime(instance.getMtime());
      this.withNlink(instance.getNlink());
      this.withPath(instance.getPath());
      this.withPercent(instance.getPercent());
      this.withPerm(instance.getPerm());
      this.withRdev(instance.getRdev());
      this.withSize(instance.getSize());
      this.withSource(instance.getSource());
      this.withType(instance.getType());
      this.withUid(instance.getUid());
      this.withAtime(instance.getAtime());
      this.withBlocks(instance.getBlocks());
      this.withCtime(instance.getCtime());
      this.withFaults(instance.getFaults());
      this.withGid(instance.getGid());
      this.withIno(instance.getIno());
      this.withKind(instance.getKind());
      this.withLatency(instance.getLatency());
      this.withMethods(instance.getMethods());
      this.withMistake(instance.getMistake());
      this.withMtime(instance.getMtime());
      this.withNlink(instance.getNlink());
      this.withPath(instance.getPath());
      this.withPercent(instance.getPercent());
      this.withPerm(instance.getPerm());
      this.withRdev(instance.getRdev());
      this.withSize(instance.getSize());
      this.withSource(instance.getSource());
      this.withType(instance.getType());
      this.withUid(instance.getUid());
    }
  }
  private TimespecBuilder atime;
  private Long blocks;
  private TimespecBuilder ctime;
  private ArrayList<IoFaultBuilder> faults = new ArrayList<IoFaultBuilder>();
  private Long gid;
  private Long ino;
  private String kind;
  private String latency;
  private List<String> methods = new ArrayList<String>();
  private MistakeSpecBuilder mistake;
  private TimespecBuilder mtime;
  private Long nlink;
  private String path;
  private Integer percent;
  private Integer perm;
  private Long rdev;
  private Long size;
  private String source;
  private String type;
  private Long uid;
  public Timespec buildAtime() {
    return this.atime!=null ?this.atime.build():null;
  }
  public A withAtime(Timespec atime) {
    _visitables.get("atime").remove(this.atime);
    if (atime!=null){ this.atime= new TimespecBuilder(atime); _visitables.get("atime").add(this.atime);} else { this.atime = null; _visitables.get("atime").remove(this.atime); } return (A) this;
  }
  public boolean hasAtime() {
    return this.atime != null;
  }
  public A withNewAtime(Long nsec,Long sec) {
    return (A)withAtime(new Timespec(nsec, sec));
  }
  public AtimeNested<A> withNewAtime() {
    return new AtimeNested(null);
  }
  public AtimeNested<A> withNewAtimeLike(Timespec item) {
    return new AtimeNested(item);
  }
  public AtimeNested<A> editAtime() {
    return withNewAtimeLike(java.util.Optional.ofNullable(buildAtime()).orElse(null));
  }
  public AtimeNested<A> editOrNewAtime() {
    return withNewAtimeLike(java.util.Optional.ofNullable(buildAtime()).orElse(new TimespecBuilder().build()));
  }
  public AtimeNested<A> editOrNewAtimeLike(Timespec item) {
    return withNewAtimeLike(java.util.Optional.ofNullable(buildAtime()).orElse(item));
  }
  public Long getBlocks() {
    return this.blocks;
  }
  public A withBlocks(Long blocks) {
    this.blocks=blocks; return (A) this;
  }
  public boolean hasBlocks() {
    return this.blocks != null;
  }
  public Timespec buildCtime() {
    return this.ctime!=null ?this.ctime.build():null;
  }
  public A withCtime(Timespec ctime) {
    _visitables.get("ctime").remove(this.ctime);
    if (ctime!=null){ this.ctime= new TimespecBuilder(ctime); _visitables.get("ctime").add(this.ctime);} else { this.ctime = null; _visitables.get("ctime").remove(this.ctime); } return (A) this;
  }
  public boolean hasCtime() {
    return this.ctime != null;
  }
  public A withNewCtime(Long nsec,Long sec) {
    return (A)withCtime(new Timespec(nsec, sec));
  }
  public CtimeNested<A> withNewCtime() {
    return new CtimeNested(null);
  }
  public CtimeNested<A> withNewCtimeLike(Timespec item) {
    return new CtimeNested(item);
  }
  public CtimeNested<A> editCtime() {
    return withNewCtimeLike(java.util.Optional.ofNullable(buildCtime()).orElse(null));
  }
  public CtimeNested<A> editOrNewCtime() {
    return withNewCtimeLike(java.util.Optional.ofNullable(buildCtime()).orElse(new TimespecBuilder().build()));
  }
  public CtimeNested<A> editOrNewCtimeLike(Timespec item) {
    return withNewCtimeLike(java.util.Optional.ofNullable(buildCtime()).orElse(item));
  }
  public A addToFaults(int index,IoFault item) {
    if (this.faults == null) {this.faults = new ArrayList<IoFaultBuilder>();}
    IoFaultBuilder builder = new IoFaultBuilder(item);
    if (index < 0 || index >= faults.size()) { _visitables.get("faults").add(builder); faults.add(builder); } else { _visitables.get("faults").add(index, builder); faults.add(index, builder);}
    return (A)this;
  }
  public A setToFaults(int index,IoFault item) {
    if (this.faults == null) {this.faults = new ArrayList<IoFaultBuilder>();}
    IoFaultBuilder builder = new IoFaultBuilder(item);
    if (index < 0 || index >= faults.size()) { _visitables.get("faults").add(builder); faults.add(builder); } else { _visitables.get("faults").set(index, builder); faults.set(index, builder);}
    return (A)this;
  }
  public A addToFaults(io.fabric8.chaosmesh.v1alpha1.IoFault... items) {
    if (this.faults == null) {this.faults = new ArrayList<IoFaultBuilder>();}
    for (IoFault item : items) {IoFaultBuilder builder = new IoFaultBuilder(item);_visitables.get("faults").add(builder);this.faults.add(builder);} return (A)this;
  }
  public A addAllToFaults(Collection<IoFault> items) {
    if (this.faults == null) {this.faults = new ArrayList<IoFaultBuilder>();}
    for (IoFault item : items) {IoFaultBuilder builder = new IoFaultBuilder(item);_visitables.get("faults").add(builder);this.faults.add(builder);} return (A)this;
  }
  public A removeFromFaults(io.fabric8.chaosmesh.v1alpha1.IoFault... items) {
    if (this.faults == null) return (A)this;
    for (IoFault item : items) {IoFaultBuilder builder = new IoFaultBuilder(item);_visitables.get("faults").remove(builder); this.faults.remove(builder);} return (A)this;
  }
  public A removeAllFromFaults(Collection<IoFault> items) {
    if (this.faults == null) return (A)this;
    for (IoFault item : items) {IoFaultBuilder builder = new IoFaultBuilder(item);_visitables.get("faults").remove(builder); this.faults.remove(builder);} return (A)this;
  }
  public A removeMatchingFromFaults(Predicate<IoFaultBuilder> predicate) {
    if (faults == null) return (A) this;
    final Iterator<IoFaultBuilder> each = faults.iterator();
    final List visitables = _visitables.get("faults");
    while (each.hasNext()) {
      IoFaultBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<IoFault> buildFaults() {
    return faults != null ? build(faults) : null;
  }
  public IoFault buildFault(int index) {
    return this.faults.get(index).build();
  }
  public IoFault buildFirstFault() {
    return this.faults.get(0).build();
  }
  public IoFault buildLastFault() {
    return this.faults.get(faults.size() - 1).build();
  }
  public IoFault buildMatchingFault(Predicate<IoFaultBuilder> predicate) {
    for (IoFaultBuilder item: faults) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingFault(Predicate<IoFaultBuilder> predicate) {
    for (IoFaultBuilder item: faults) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withFaults(List<IoFault> faults) {
    if (this.faults != null) { _visitables.get("faults").clear();}
    if (faults != null) {this.faults = new ArrayList(); for (IoFault item : faults){this.addToFaults(item);}} else { this.faults = null;} return (A) this;
  }
  public A withFaults(io.fabric8.chaosmesh.v1alpha1.IoFault... faults) {
    if (this.faults != null) {this.faults.clear(); _visitables.remove("faults"); }
    if (faults != null) {for (IoFault item :faults){ this.addToFaults(item);}} return (A) this;
  }
  public boolean hasFaults() {
    return faults != null && !faults.isEmpty();
  }
  public A addNewFault(Integer errno,Integer weight) {
    return (A)addToFaults(new IoFault(errno, weight));
  }
  public FaultsNested<A> addNewFault() {
    return new FaultsNested(-1, null);
  }
  public FaultsNested<A> addNewFaultLike(IoFault item) {
    return new FaultsNested(-1, item);
  }
  public FaultsNested<A> setNewFaultLike(int index,IoFault item) {
    return new FaultsNested(index, item);
  }
  public FaultsNested<A> editFault(int index) {
    if (faults.size() <= index) throw new RuntimeException("Can't edit faults. Index exceeds size.");
    return setNewFaultLike(index, buildFault(index));
  }
  public FaultsNested<A> editFirstFault() {
    if (faults.size() == 0) throw new RuntimeException("Can't edit first faults. The list is empty.");
    return setNewFaultLike(0, buildFault(0));
  }
  public FaultsNested<A> editLastFault() {
    int index = faults.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last faults. The list is empty.");
    return setNewFaultLike(index, buildFault(index));
  }
  public FaultsNested<A> editMatchingFault(Predicate<IoFaultBuilder> predicate) {
    int index = -1;
    for (int i=0;i<faults.size();i++) { 
    if (predicate.test(faults.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching faults. No match found.");
    return setNewFaultLike(index, buildFault(index));
  }
  public Long getGid() {
    return this.gid;
  }
  public A withGid(Long gid) {
    this.gid=gid; return (A) this;
  }
  public boolean hasGid() {
    return this.gid != null;
  }
  public Long getIno() {
    return this.ino;
  }
  public A withIno(Long ino) {
    this.ino=ino; return (A) this;
  }
  public boolean hasIno() {
    return this.ino != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public boolean hasKind() {
    return this.kind != null;
  }
  public String getLatency() {
    return this.latency;
  }
  public A withLatency(String latency) {
    this.latency=latency; return (A) this;
  }
  public boolean hasLatency() {
    return this.latency != null;
  }
  public A addToMethods(int index,String item) {
    if (this.methods == null) {this.methods = new ArrayList<String>();}
    this.methods.add(index, item);
    return (A)this;
  }
  public A setToMethods(int index,String item) {
    if (this.methods == null) {this.methods = new ArrayList<String>();}
    this.methods.set(index, item); return (A)this;
  }
  public A addToMethods(java.lang.String... items) {
    if (this.methods == null) {this.methods = new ArrayList<String>();}
    for (String item : items) {this.methods.add(item);} return (A)this;
  }
  public A addAllToMethods(Collection<String> items) {
    if (this.methods == null) {this.methods = new ArrayList<String>();}
    for (String item : items) {this.methods.add(item);} return (A)this;
  }
  public A removeFromMethods(java.lang.String... items) {
    if (this.methods == null) return (A)this;
    for (String item : items) { this.methods.remove(item);} return (A)this;
  }
  public A removeAllFromMethods(Collection<String> items) {
    if (this.methods == null) return (A)this;
    for (String item : items) { this.methods.remove(item);} return (A)this;
  }
  public List<String> getMethods() {
    return this.methods;
  }
  public String getMethod(int index) {
    return this.methods.get(index);
  }
  public String getFirstMethod() {
    return this.methods.get(0);
  }
  public String getLastMethod() {
    return this.methods.get(methods.size() - 1);
  }
  public String getMatchingMethod(Predicate<String> predicate) {
    for (String item: methods) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingMethod(Predicate<String> predicate) {
    for (String item: methods) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMethods(List<String> methods) {
    if (methods != null) {this.methods = new ArrayList(); for (String item : methods){this.addToMethods(item);}} else { this.methods = null;} return (A) this;
  }
  public A withMethods(java.lang.String... methods) {
    if (this.methods != null) {this.methods.clear(); _visitables.remove("methods"); }
    if (methods != null) {for (String item :methods){ this.addToMethods(item);}} return (A) this;
  }
  public boolean hasMethods() {
    return methods != null && !methods.isEmpty();
  }
  public MistakeSpec buildMistake() {
    return this.mistake!=null ?this.mistake.build():null;
  }
  public A withMistake(MistakeSpec mistake) {
    _visitables.get("mistake").remove(this.mistake);
    if (mistake!=null){ this.mistake= new MistakeSpecBuilder(mistake); _visitables.get("mistake").add(this.mistake);} else { this.mistake = null; _visitables.get("mistake").remove(this.mistake); } return (A) this;
  }
  public boolean hasMistake() {
    return this.mistake != null;
  }
  public A withNewMistake(String filling,Long maxLength,Long maxOccurrences) {
    return (A)withMistake(new MistakeSpec(filling, maxLength, maxOccurrences));
  }
  public MistakeNested<A> withNewMistake() {
    return new MistakeNested(null);
  }
  public MistakeNested<A> withNewMistakeLike(MistakeSpec item) {
    return new MistakeNested(item);
  }
  public MistakeNested<A> editMistake() {
    return withNewMistakeLike(java.util.Optional.ofNullable(buildMistake()).orElse(null));
  }
  public MistakeNested<A> editOrNewMistake() {
    return withNewMistakeLike(java.util.Optional.ofNullable(buildMistake()).orElse(new MistakeSpecBuilder().build()));
  }
  public MistakeNested<A> editOrNewMistakeLike(MistakeSpec item) {
    return withNewMistakeLike(java.util.Optional.ofNullable(buildMistake()).orElse(item));
  }
  public Timespec buildMtime() {
    return this.mtime!=null ?this.mtime.build():null;
  }
  public A withMtime(Timespec mtime) {
    _visitables.get("mtime").remove(this.mtime);
    if (mtime!=null){ this.mtime= new TimespecBuilder(mtime); _visitables.get("mtime").add(this.mtime);} else { this.mtime = null; _visitables.get("mtime").remove(this.mtime); } return (A) this;
  }
  public boolean hasMtime() {
    return this.mtime != null;
  }
  public A withNewMtime(Long nsec,Long sec) {
    return (A)withMtime(new Timespec(nsec, sec));
  }
  public MtimeNested<A> withNewMtime() {
    return new MtimeNested(null);
  }
  public MtimeNested<A> withNewMtimeLike(Timespec item) {
    return new MtimeNested(item);
  }
  public MtimeNested<A> editMtime() {
    return withNewMtimeLike(java.util.Optional.ofNullable(buildMtime()).orElse(null));
  }
  public MtimeNested<A> editOrNewMtime() {
    return withNewMtimeLike(java.util.Optional.ofNullable(buildMtime()).orElse(new TimespecBuilder().build()));
  }
  public MtimeNested<A> editOrNewMtimeLike(Timespec item) {
    return withNewMtimeLike(java.util.Optional.ofNullable(buildMtime()).orElse(item));
  }
  public Long getNlink() {
    return this.nlink;
  }
  public A withNlink(Long nlink) {
    this.nlink=nlink; return (A) this;
  }
  public boolean hasNlink() {
    return this.nlink != null;
  }
  public String getPath() {
    return this.path;
  }
  public A withPath(String path) {
    this.path=path; return (A) this;
  }
  public boolean hasPath() {
    return this.path != null;
  }
  public Integer getPercent() {
    return this.percent;
  }
  public A withPercent(Integer percent) {
    this.percent=percent; return (A) this;
  }
  public boolean hasPercent() {
    return this.percent != null;
  }
  public Integer getPerm() {
    return this.perm;
  }
  public A withPerm(Integer perm) {
    this.perm=perm; return (A) this;
  }
  public boolean hasPerm() {
    return this.perm != null;
  }
  public Long getRdev() {
    return this.rdev;
  }
  public A withRdev(Long rdev) {
    this.rdev=rdev; return (A) this;
  }
  public boolean hasRdev() {
    return this.rdev != null;
  }
  public Long getSize() {
    return this.size;
  }
  public A withSize(Long size) {
    this.size=size; return (A) this;
  }
  public boolean hasSize() {
    return this.size != null;
  }
  public String getSource() {
    return this.source;
  }
  public A withSource(String source) {
    this.source=source; return (A) this;
  }
  public boolean hasSource() {
    return this.source != null;
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public boolean hasType() {
    return this.type != null;
  }
  public Long getUid() {
    return this.uid;
  }
  public A withUid(Long uid) {
    this.uid=uid; return (A) this;
  }
  public boolean hasUid() {
    return this.uid != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IOChaosActionFluent that = (IOChaosActionFluent) o;
    if (!java.util.Objects.equals(atime, that.atime)) return false;

    if (!java.util.Objects.equals(blocks, that.blocks)) return false;

    if (!java.util.Objects.equals(ctime, that.ctime)) return false;

    if (!java.util.Objects.equals(faults, that.faults)) return false;

    if (!java.util.Objects.equals(gid, that.gid)) return false;

    if (!java.util.Objects.equals(ino, that.ino)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(latency, that.latency)) return false;

    if (!java.util.Objects.equals(methods, that.methods)) return false;

    if (!java.util.Objects.equals(mistake, that.mistake)) return false;

    if (!java.util.Objects.equals(mtime, that.mtime)) return false;

    if (!java.util.Objects.equals(nlink, that.nlink)) return false;

    if (!java.util.Objects.equals(path, that.path)) return false;

    if (!java.util.Objects.equals(percent, that.percent)) return false;

    if (!java.util.Objects.equals(perm, that.perm)) return false;

    if (!java.util.Objects.equals(rdev, that.rdev)) return false;

    if (!java.util.Objects.equals(size, that.size)) return false;

    if (!java.util.Objects.equals(source, that.source)) return false;

    if (!java.util.Objects.equals(type, that.type)) return false;

    if (!java.util.Objects.equals(uid, that.uid)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(atime,  blocks,  ctime,  faults,  gid,  ino,  kind,  latency,  methods,  mistake,  mtime,  nlink,  path,  percent,  perm,  rdev,  size,  source,  type,  uid,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (atime != null) { sb.append("atime:"); sb.append(atime + ","); }
    if (blocks != null) { sb.append("blocks:"); sb.append(blocks + ","); }
    if (ctime != null) { sb.append("ctime:"); sb.append(ctime + ","); }
    if (faults != null && !faults.isEmpty()) { sb.append("faults:"); sb.append(faults + ","); }
    if (gid != null) { sb.append("gid:"); sb.append(gid + ","); }
    if (ino != null) { sb.append("ino:"); sb.append(ino + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (latency != null) { sb.append("latency:"); sb.append(latency + ","); }
    if (methods != null && !methods.isEmpty()) { sb.append("methods:"); sb.append(methods + ","); }
    if (mistake != null) { sb.append("mistake:"); sb.append(mistake + ","); }
    if (mtime != null) { sb.append("mtime:"); sb.append(mtime + ","); }
    if (nlink != null) { sb.append("nlink:"); sb.append(nlink + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (percent != null) { sb.append("percent:"); sb.append(percent + ","); }
    if (perm != null) { sb.append("perm:"); sb.append(perm + ","); }
    if (rdev != null) { sb.append("rdev:"); sb.append(rdev + ","); }
    if (size != null) { sb.append("size:"); sb.append(size + ","); }
    if (source != null) { sb.append("source:"); sb.append(source + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (uid != null) { sb.append("uid:"); sb.append(uid); }
    sb.append("}");
    return sb.toString();
  }
  public class AtimeNested<N> extends TimespecFluent<AtimeNested<N>> implements Nested<N>{
    AtimeNested(Timespec item) {
      this.builder = new TimespecBuilder(this, item);
    }
    TimespecBuilder builder;
    public N and() {
      return (N) IOChaosActionFluent.this.withAtime(builder.build());
    }
    public N endAtime() {
      return and();
    }
    
  }
  public class CtimeNested<N> extends TimespecFluent<CtimeNested<N>> implements Nested<N>{
    CtimeNested(Timespec item) {
      this.builder = new TimespecBuilder(this, item);
    }
    TimespecBuilder builder;
    public N and() {
      return (N) IOChaosActionFluent.this.withCtime(builder.build());
    }
    public N endCtime() {
      return and();
    }
    
  }
  public class FaultsNested<N> extends IoFaultFluent<FaultsNested<N>> implements Nested<N>{
    FaultsNested(int index,IoFault item) {
      this.index = index;
      this.builder = new IoFaultBuilder(this, item);
    }
    IoFaultBuilder builder;
    int index;
    public N and() {
      return (N) IOChaosActionFluent.this.setToFaults(index,builder.build());
    }
    public N endFault() {
      return and();
    }
    
  }
  public class MistakeNested<N> extends MistakeSpecFluent<MistakeNested<N>> implements Nested<N>{
    MistakeNested(MistakeSpec item) {
      this.builder = new MistakeSpecBuilder(this, item);
    }
    MistakeSpecBuilder builder;
    public N and() {
      return (N) IOChaosActionFluent.this.withMistake(builder.build());
    }
    public N endMistake() {
      return and();
    }
    
  }
  public class MtimeNested<N> extends TimespecFluent<MtimeNested<N>> implements Nested<N>{
    MtimeNested(Timespec item) {
      this.builder = new TimespecBuilder(this, item);
    }
    TimespecBuilder builder;
    public N and() {
      return (N) IOChaosActionFluent.this.withMtime(builder.build());
    }
    public N endMtime() {
      return and();
    }
    
  }
  
}