package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPChaosListBuilder extends HTTPChaosListFluent<HTTPChaosListBuilder> implements VisitableBuilder<HTTPChaosList,HTTPChaosListBuilder>{
  public HTTPChaosListBuilder() {
    this(false);
  }
  public HTTPChaosListBuilder(Boolean validationEnabled) {
    this(new HTTPChaosList(), validationEnabled);
  }
  public HTTPChaosListBuilder(HTTPChaosListFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPChaosListBuilder(HTTPChaosListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPChaosList(), validationEnabled);
  }
  public HTTPChaosListBuilder(HTTPChaosListFluent<?> fluent,HTTPChaosList instance) {
    this(fluent, instance, false);
  }
  public HTTPChaosListBuilder(HTTPChaosListFluent<?> fluent,HTTPChaosList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new HTTPChaosList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HTTPChaosListBuilder(HTTPChaosList instance) {
    this(instance,false);
  }
  public HTTPChaosListBuilder(HTTPChaosList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new HTTPChaosList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  HTTPChaosListFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPChaosList build() {
    HTTPChaosList buildable = new HTTPChaosList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}