package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DiskFillSpecBuilder extends DiskFillSpecFluent<DiskFillSpecBuilder> implements VisitableBuilder<DiskFillSpec,DiskFillSpecBuilder>{
  public DiskFillSpecBuilder() {
    this(false);
  }
  public DiskFillSpecBuilder(Boolean validationEnabled) {
    this(new DiskFillSpec(), validationEnabled);
  }
  public DiskFillSpecBuilder(DiskFillSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public DiskFillSpecBuilder(DiskFillSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DiskFillSpec(), validationEnabled);
  }
  public DiskFillSpecBuilder(DiskFillSpecFluent<?> fluent,DiskFillSpec instance) {
    this(fluent, instance, false);
  }
  public DiskFillSpecBuilder(DiskFillSpecFluent<?> fluent,DiskFillSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DiskFillSpec());

    if (instance != null) {
      fluent.withFillByFallocate(instance.getFillByFallocate());
      fluent.withPath(instance.getPath());
      fluent.withSize(instance.getSize());
      fluent.withFillByFallocate(instance.getFillByFallocate());
      fluent.withPath(instance.getPath());
      fluent.withSize(instance.getSize());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DiskFillSpecBuilder(DiskFillSpec instance) {
    this(instance,false);
  }
  public DiskFillSpecBuilder(DiskFillSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DiskFillSpec());

    if (instance != null) {
      this.withFillByFallocate(instance.getFillByFallocate());
      this.withPath(instance.getPath());
      this.withSize(instance.getSize());
      this.withFillByFallocate(instance.getFillByFallocate());
      this.withPath(instance.getPath());
      this.withSize(instance.getSize());
    }
    this.validationEnabled = validationEnabled; 
  }
  DiskFillSpecFluent<?> fluent;
  Boolean validationEnabled;
  public DiskFillSpec build() {
    DiskFillSpec buildable = new DiskFillSpec(fluent.getFillByFallocate(),fluent.getPath(),fluent.getSize());
    return buildable;
  }
  
}