package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ChaosConditionBuilder extends ChaosConditionFluent<ChaosConditionBuilder> implements VisitableBuilder<ChaosCondition,ChaosConditionBuilder>{
  public ChaosConditionBuilder() {
    this(false);
  }
  public ChaosConditionBuilder(Boolean validationEnabled) {
    this(new ChaosCondition(), validationEnabled);
  }
  public ChaosConditionBuilder(ChaosConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public ChaosConditionBuilder(ChaosConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ChaosCondition(), validationEnabled);
  }
  public ChaosConditionBuilder(ChaosConditionFluent<?> fluent,ChaosCondition instance) {
    this(fluent, instance, false);
  }
  public ChaosConditionBuilder(ChaosConditionFluent<?> fluent,ChaosCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ChaosCondition());

    if (instance != null) {
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ChaosConditionBuilder(ChaosCondition instance) {
    this(instance,false);
  }
  public ChaosConditionBuilder(ChaosCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ChaosCondition());

    if (instance != null) {
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  ChaosConditionFluent<?> fluent;
  Boolean validationEnabled;
  public ChaosCondition build() {
    ChaosCondition buildable = new ChaosCondition(fluent.getReason(),fluent.getStatus(),fluent.getType());
    return buildable;
  }
  
}