package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AWSChaosSpecBuilder extends AWSChaosSpecFluent<AWSChaosSpecBuilder> implements VisitableBuilder<AWSChaosSpec,AWSChaosSpecBuilder>{
  public AWSChaosSpecBuilder() {
    this(false);
  }
  public AWSChaosSpecBuilder(Boolean validationEnabled) {
    this(new AWSChaosSpec(), validationEnabled);
  }
  public AWSChaosSpecBuilder(AWSChaosSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSChaosSpecBuilder(AWSChaosSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AWSChaosSpec(), validationEnabled);
  }
  public AWSChaosSpecBuilder(AWSChaosSpecFluent<?> fluent,AWSChaosSpec instance) {
    this(fluent, instance, false);
  }
  public AWSChaosSpecBuilder(AWSChaosSpecFluent<?> fluent,AWSChaosSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AWSChaosSpec());

    if (instance != null) {
      fluent.withAction(instance.getAction());
      fluent.withAwsRegion(instance.getAwsRegion());
      fluent.withDeviceName(instance.getDeviceName());
      fluent.withDuration(instance.getDuration());
      fluent.withEc2Instance(instance.getEc2Instance());
      fluent.withEndpoint(instance.getEndpoint());
      fluent.withSecretName(instance.getSecretName());
      fluent.withVolumeID(instance.getVolumeID());
      fluent.withAction(instance.getAction());
      fluent.withAwsRegion(instance.getAwsRegion());
      fluent.withDeviceName(instance.getDeviceName());
      fluent.withDuration(instance.getDuration());
      fluent.withEc2Instance(instance.getEc2Instance());
      fluent.withEndpoint(instance.getEndpoint());
      fluent.withSecretName(instance.getSecretName());
      fluent.withVolumeID(instance.getVolumeID());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AWSChaosSpecBuilder(AWSChaosSpec instance) {
    this(instance,false);
  }
  public AWSChaosSpecBuilder(AWSChaosSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AWSChaosSpec());

    if (instance != null) {
      this.withAction(instance.getAction());
      this.withAwsRegion(instance.getAwsRegion());
      this.withDeviceName(instance.getDeviceName());
      this.withDuration(instance.getDuration());
      this.withEc2Instance(instance.getEc2Instance());
      this.withEndpoint(instance.getEndpoint());
      this.withSecretName(instance.getSecretName());
      this.withVolumeID(instance.getVolumeID());
      this.withAction(instance.getAction());
      this.withAwsRegion(instance.getAwsRegion());
      this.withDeviceName(instance.getDeviceName());
      this.withDuration(instance.getDuration());
      this.withEc2Instance(instance.getEc2Instance());
      this.withEndpoint(instance.getEndpoint());
      this.withSecretName(instance.getSecretName());
      this.withVolumeID(instance.getVolumeID());
    }
    this.validationEnabled = validationEnabled; 
  }
  AWSChaosSpecFluent<?> fluent;
  Boolean validationEnabled;
  public AWSChaosSpec build() {
    AWSChaosSpec buildable = new AWSChaosSpec(fluent.getAction(),fluent.getAwsRegion(),fluent.getDeviceName(),fluent.getDuration(),fluent.getEc2Instance(),fluent.getEndpoint(),fluent.getSecretName(),fluent.getVolumeID());
    return buildable;
  }
  
}