/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.chaosmesh.v1alpha1.RawIPSet;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class RawIPSetFluent<A extends RawIPSetFluent<A>>
extends BaseFluent<A> {
    private List<String> cidrs = new ArrayList<String>();
    private String name;
    private String source;

    public RawIPSetFluent() {
    }

    public RawIPSetFluent(RawIPSet instance) {
        RawIPSet rawIPSet = instance = instance != null ? instance : new RawIPSet();
        if (instance != null) {
            this.withCidrs(instance.getCidrs());
            this.withName(instance.getName());
            this.withSource(instance.getSource());
            this.withCidrs(instance.getCidrs());
            this.withName(instance.getName());
            this.withSource(instance.getSource());
        }
    }

    public A addToCidrs(int index, String item) {
        if (this.cidrs == null) {
            this.cidrs = new ArrayList<String>();
        }
        this.cidrs.add(index, item);
        return (A)((Object)this);
    }

    public A setToCidrs(int index, String item) {
        if (this.cidrs == null) {
            this.cidrs = new ArrayList<String>();
        }
        this.cidrs.set(index, item);
        return (A)((Object)this);
    }

    public A addToCidrs(String ... items) {
        if (this.cidrs == null) {
            this.cidrs = new ArrayList<String>();
        }
        for (String item : items) {
            this.cidrs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToCidrs(Collection<String> items) {
        if (this.cidrs == null) {
            this.cidrs = new ArrayList<String>();
        }
        for (String item : items) {
            this.cidrs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromCidrs(String ... items) {
        if (this.cidrs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.cidrs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCidrs(Collection<String> items) {
        if (this.cidrs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.cidrs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getCidrs() {
        return this.cidrs;
    }

    public String getCidr(int index) {
        return this.cidrs.get(index);
    }

    public String getFirstCidr() {
        return this.cidrs.get(0);
    }

    public String getLastCidr() {
        return this.cidrs.get(this.cidrs.size() - 1);
    }

    public String getMatchingCidr(Predicate<String> predicate) {
        for (String item : this.cidrs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCidr(Predicate<String> predicate) {
        for (String item : this.cidrs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCidrs(List<String> cidrs) {
        if (cidrs != null) {
            this.cidrs = new ArrayList<String>();
            for (String item : cidrs) {
                this.addToCidrs(item);
            }
        } else {
            this.cidrs = null;
        }
        return (A)((Object)this);
    }

    public A withCidrs(String ... cidrs) {
        if (this.cidrs != null) {
            this.cidrs.clear();
            this._visitables.remove((Object)"cidrs");
        }
        if (cidrs != null) {
            for (String item : cidrs) {
                this.addToCidrs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasCidrs() {
        return this.cidrs != null && !this.cidrs.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getSource() {
        return this.source;
    }

    public A withSource(String source) {
        this.source = source;
        return (A)((Object)this);
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RawIPSetFluent that = (RawIPSetFluent)((Object)o);
        if (!Objects.equals(this.cidrs, that.cidrs)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.source, that.source);
    }

    public int hashCode() {
        return Objects.hash(this.cidrs, this.name, this.source, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cidrs != null && !this.cidrs.isEmpty()) {
            sb.append("cidrs:");
            sb.append(this.cidrs + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.source != null) {
            sb.append("source:");
            sb.append(this.source);
        }
        sb.append("}");
        return sb.toString();
    }
}

