package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StressInstanceBuilder extends StressInstanceFluent<StressInstanceBuilder> implements VisitableBuilder<StressInstance,StressInstanceBuilder>{
  public StressInstanceBuilder() {
    this(false);
  }
  public StressInstanceBuilder(Boolean validationEnabled) {
    this(new StressInstance(), validationEnabled);
  }
  public StressInstanceBuilder(StressInstanceFluent<?> fluent) {
    this(fluent, false);
  }
  public StressInstanceBuilder(StressInstanceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StressInstance(), validationEnabled);
  }
  public StressInstanceBuilder(StressInstanceFluent<?> fluent,StressInstance instance) {
    this(fluent, instance, false);
  }
  public StressInstanceBuilder(StressInstanceFluent<?> fluent,StressInstance instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new StressInstance());

    if (instance != null) {
      fluent.withMemoryStartTime(instance.getMemoryStartTime());
      fluent.withMemoryUid(instance.getMemoryUid());
      fluent.withStartTime(instance.getStartTime());
      fluent.withUid(instance.getUid());
      fluent.withMemoryStartTime(instance.getMemoryStartTime());
      fluent.withMemoryUid(instance.getMemoryUid());
      fluent.withStartTime(instance.getStartTime());
      fluent.withUid(instance.getUid());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StressInstanceBuilder(StressInstance instance) {
    this(instance,false);
  }
  public StressInstanceBuilder(StressInstance instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new StressInstance());

    if (instance != null) {
      this.withMemoryStartTime(instance.getMemoryStartTime());
      this.withMemoryUid(instance.getMemoryUid());
      this.withStartTime(instance.getStartTime());
      this.withUid(instance.getUid());
      this.withMemoryStartTime(instance.getMemoryStartTime());
      this.withMemoryUid(instance.getMemoryUid());
      this.withStartTime(instance.getStartTime());
      this.withUid(instance.getUid());
    }
    this.validationEnabled = validationEnabled; 
  }
  StressInstanceFluent<?> fluent;
  Boolean validationEnabled;
  public StressInstance build() {
    StressInstance buildable = new StressInstance(fluent.getMemoryStartTime(),fluent.getMemoryUid(),fluent.getStartTime(),fluent.getUid());
    return buildable;
  }
  
}