package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StressChaosBuilder extends StressChaosFluent<StressChaosBuilder> implements VisitableBuilder<StressChaos,StressChaosBuilder>{
  public StressChaosBuilder() {
    this(false);
  }
  public StressChaosBuilder(Boolean validationEnabled) {
    this(new StressChaos(), validationEnabled);
  }
  public StressChaosBuilder(StressChaosFluent<?> fluent) {
    this(fluent, false);
  }
  public StressChaosBuilder(StressChaosFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StressChaos(), validationEnabled);
  }
  public StressChaosBuilder(StressChaosFluent<?> fluent,StressChaos instance) {
    this(fluent, instance, false);
  }
  public StressChaosBuilder(StressChaosFluent<?> fluent,StressChaos instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new StressChaos());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StressChaosBuilder(StressChaos instance) {
    this(instance,false);
  }
  public StressChaosBuilder(StressChaos instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new StressChaos());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  StressChaosFluent<?> fluent;
  Boolean validationEnabled;
  public StressChaos build() {
    StressChaos buildable = new StressChaos(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}