package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RawTrafficControlBuilder extends RawTrafficControlFluent<RawTrafficControlBuilder> implements VisitableBuilder<RawTrafficControl,RawTrafficControlBuilder>{
  public RawTrafficControlBuilder() {
    this(false);
  }
  public RawTrafficControlBuilder(Boolean validationEnabled) {
    this(new RawTrafficControl(), validationEnabled);
  }
  public RawTrafficControlBuilder(RawTrafficControlFluent<?> fluent) {
    this(fluent, false);
  }
  public RawTrafficControlBuilder(RawTrafficControlFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RawTrafficControl(), validationEnabled);
  }
  public RawTrafficControlBuilder(RawTrafficControlFluent<?> fluent,RawTrafficControl instance) {
    this(fluent, instance, false);
  }
  public RawTrafficControlBuilder(RawTrafficControlFluent<?> fluent,RawTrafficControl instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new RawTrafficControl());

    if (instance != null) {
      fluent.withBandwidth(instance.getBandwidth());
      fluent.withCorrupt(instance.getCorrupt());
      fluent.withDelay(instance.getDelay());
      fluent.withDevice(instance.getDevice());
      fluent.withDuplicate(instance.getDuplicate());
      fluent.withIpset(instance.getIpset());
      fluent.withLoss(instance.getLoss());
      fluent.withSource(instance.getSource());
      fluent.withType(instance.getType());
      fluent.withBandwidth(instance.getBandwidth());
      fluent.withCorrupt(instance.getCorrupt());
      fluent.withDelay(instance.getDelay());
      fluent.withDevice(instance.getDevice());
      fluent.withDuplicate(instance.getDuplicate());
      fluent.withIpset(instance.getIpset());
      fluent.withLoss(instance.getLoss());
      fluent.withSource(instance.getSource());
      fluent.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RawTrafficControlBuilder(RawTrafficControl instance) {
    this(instance,false);
  }
  public RawTrafficControlBuilder(RawTrafficControl instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new RawTrafficControl());

    if (instance != null) {
      this.withBandwidth(instance.getBandwidth());
      this.withCorrupt(instance.getCorrupt());
      this.withDelay(instance.getDelay());
      this.withDevice(instance.getDevice());
      this.withDuplicate(instance.getDuplicate());
      this.withIpset(instance.getIpset());
      this.withLoss(instance.getLoss());
      this.withSource(instance.getSource());
      this.withType(instance.getType());
      this.withBandwidth(instance.getBandwidth());
      this.withCorrupt(instance.getCorrupt());
      this.withDelay(instance.getDelay());
      this.withDevice(instance.getDevice());
      this.withDuplicate(instance.getDuplicate());
      this.withIpset(instance.getIpset());
      this.withLoss(instance.getLoss());
      this.withSource(instance.getSource());
      this.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  RawTrafficControlFluent<?> fluent;
  Boolean validationEnabled;
  public RawTrafficControl build() {
    RawTrafficControl buildable = new RawTrafficControl(fluent.buildBandwidth(),fluent.buildCorrupt(),fluent.buildDelay(),fluent.getDevice(),fluent.buildDuplicate(),fluent.getIpset(),fluent.buildLoss(),fluent.getSource(),fluent.getType());
    return buildable;
  }
  
}