package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodSelectorBuilder extends PodSelectorFluent<PodSelectorBuilder> implements VisitableBuilder<PodSelector,PodSelectorBuilder>{
  public PodSelectorBuilder() {
    this(false);
  }
  public PodSelectorBuilder(Boolean validationEnabled) {
    this(new PodSelector(), validationEnabled);
  }
  public PodSelectorBuilder(PodSelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public PodSelectorBuilder(PodSelectorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodSelector(), validationEnabled);
  }
  public PodSelectorBuilder(PodSelectorFluent<?> fluent,PodSelector instance) {
    this(fluent, instance, false);
  }
  public PodSelectorBuilder(PodSelectorFluent<?> fluent,PodSelector instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodSelector());

    if (instance != null) {
      fluent.withMode(instance.getMode());
      fluent.withSelector(instance.getSelector());
      fluent.withValue(instance.getValue());
      fluent.withMode(instance.getMode());
      fluent.withSelector(instance.getSelector());
      fluent.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodSelectorBuilder(PodSelector instance) {
    this(instance,false);
  }
  public PodSelectorBuilder(PodSelector instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodSelector());

    if (instance != null) {
      this.withMode(instance.getMode());
      this.withSelector(instance.getSelector());
      this.withValue(instance.getValue());
      this.withMode(instance.getMode());
      this.withSelector(instance.getSelector());
      this.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodSelectorFluent<?> fluent;
  Boolean validationEnabled;
  public PodSelector build() {
    PodSelector buildable = new PodSelector(fluent.getMode(),fluent.buildSelector(),fluent.getValue());
    return buildable;
  }
  
}