package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodNetworkChaosBuilder extends PodNetworkChaosFluent<PodNetworkChaosBuilder> implements VisitableBuilder<PodNetworkChaos,PodNetworkChaosBuilder>{
  public PodNetworkChaosBuilder() {
    this(false);
  }
  public PodNetworkChaosBuilder(Boolean validationEnabled) {
    this(new PodNetworkChaos(), validationEnabled);
  }
  public PodNetworkChaosBuilder(PodNetworkChaosFluent<?> fluent) {
    this(fluent, false);
  }
  public PodNetworkChaosBuilder(PodNetworkChaosFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodNetworkChaos(), validationEnabled);
  }
  public PodNetworkChaosBuilder(PodNetworkChaosFluent<?> fluent,PodNetworkChaos instance) {
    this(fluent, instance, false);
  }
  public PodNetworkChaosBuilder(PodNetworkChaosFluent<?> fluent,PodNetworkChaos instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodNetworkChaos());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodNetworkChaosBuilder(PodNetworkChaos instance) {
    this(instance,false);
  }
  public PodNetworkChaosBuilder(PodNetworkChaos instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodNetworkChaos());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodNetworkChaosFluent<?> fluent;
  Boolean validationEnabled;
  public PodNetworkChaos build() {
    PodNetworkChaos buildable = new PodNetworkChaos(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}