package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodIOChaosBuilder extends PodIOChaosFluent<PodIOChaosBuilder> implements VisitableBuilder<PodIOChaos,PodIOChaosBuilder>{
  public PodIOChaosBuilder() {
    this(false);
  }
  public PodIOChaosBuilder(Boolean validationEnabled) {
    this(new PodIOChaos(), validationEnabled);
  }
  public PodIOChaosBuilder(PodIOChaosFluent<?> fluent) {
    this(fluent, false);
  }
  public PodIOChaosBuilder(PodIOChaosFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodIOChaos(), validationEnabled);
  }
  public PodIOChaosBuilder(PodIOChaosFluent<?> fluent,PodIOChaos instance) {
    this(fluent, instance, false);
  }
  public PodIOChaosBuilder(PodIOChaosFluent<?> fluent,PodIOChaos instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodIOChaos());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodIOChaosBuilder(PodIOChaos instance) {
    this(instance,false);
  }
  public PodIOChaosBuilder(PodIOChaos instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodIOChaos());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodIOChaosFluent<?> fluent;
  Boolean validationEnabled;
  public PodIOChaos build() {
    PodIOChaos buildable = new PodIOChaos(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}