package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodHttpChaosBuilder extends PodHttpChaosFluent<PodHttpChaosBuilder> implements VisitableBuilder<PodHttpChaos,PodHttpChaosBuilder>{
  public PodHttpChaosBuilder() {
    this(false);
  }
  public PodHttpChaosBuilder(Boolean validationEnabled) {
    this(new PodHttpChaos(), validationEnabled);
  }
  public PodHttpChaosBuilder(PodHttpChaosFluent<?> fluent) {
    this(fluent, false);
  }
  public PodHttpChaosBuilder(PodHttpChaosFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodHttpChaos(), validationEnabled);
  }
  public PodHttpChaosBuilder(PodHttpChaosFluent<?> fluent,PodHttpChaos instance) {
    this(fluent, instance, false);
  }
  public PodHttpChaosBuilder(PodHttpChaosFluent<?> fluent,PodHttpChaos instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodHttpChaos());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodHttpChaosBuilder(PodHttpChaos instance) {
    this(instance,false);
  }
  public PodHttpChaosBuilder(PodHttpChaos instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodHttpChaos());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodHttpChaosFluent<?> fluent;
  Boolean validationEnabled;
  public PodHttpChaos build() {
    PodHttpChaos buildable = new PodHttpChaos(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}