package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodChaosStatusBuilder extends PodChaosStatusFluent<PodChaosStatusBuilder> implements VisitableBuilder<PodChaosStatus,PodChaosStatusBuilder>{
  public PodChaosStatusBuilder() {
    this(false);
  }
  public PodChaosStatusBuilder(Boolean validationEnabled) {
    this(new PodChaosStatus(), validationEnabled);
  }
  public PodChaosStatusBuilder(PodChaosStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PodChaosStatusBuilder(PodChaosStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodChaosStatus(), validationEnabled);
  }
  public PodChaosStatusBuilder(PodChaosStatusFluent<?> fluent,PodChaosStatus instance) {
    this(fluent, instance, false);
  }
  public PodChaosStatusBuilder(PodChaosStatusFluent<?> fluent,PodChaosStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodChaosStatus());

    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withExperiment(instance.getExperiment());
      fluent.withConditions(instance.getConditions());
      fluent.withExperiment(instance.getExperiment());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodChaosStatusBuilder(PodChaosStatus instance) {
    this(instance,false);
  }
  public PodChaosStatusBuilder(PodChaosStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodChaosStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withExperiment(instance.getExperiment());
      this.withConditions(instance.getConditions());
      this.withExperiment(instance.getExperiment());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodChaosStatusFluent<?> fluent;
  Boolean validationEnabled;
  public PodChaosStatus build() {
    PodChaosStatus buildable = new PodChaosStatus(fluent.buildConditions(),fluent.buildExperiment());
    return buildable;
  }
  
}