package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IOChaosBuilder extends IOChaosFluent<IOChaosBuilder> implements VisitableBuilder<IOChaos,IOChaosBuilder>{
  public IOChaosBuilder() {
    this(false);
  }
  public IOChaosBuilder(Boolean validationEnabled) {
    this(new IOChaos(), validationEnabled);
  }
  public IOChaosBuilder(IOChaosFluent<?> fluent) {
    this(fluent, false);
  }
  public IOChaosBuilder(IOChaosFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IOChaos(), validationEnabled);
  }
  public IOChaosBuilder(IOChaosFluent<?> fluent,IOChaos instance) {
    this(fluent, instance, false);
  }
  public IOChaosBuilder(IOChaosFluent<?> fluent,IOChaos instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new IOChaos());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IOChaosBuilder(IOChaos instance) {
    this(instance,false);
  }
  public IOChaosBuilder(IOChaos instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new IOChaos());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  IOChaosFluent<?> fluent;
  Boolean validationEnabled;
  public IOChaos build() {
    IOChaos buildable = new IOChaos(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}