package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPChaosStatusBuilder extends HTTPChaosStatusFluent<HTTPChaosStatusBuilder> implements VisitableBuilder<HTTPChaosStatus,HTTPChaosStatusBuilder>{
  public HTTPChaosStatusBuilder() {
    this(false);
  }
  public HTTPChaosStatusBuilder(Boolean validationEnabled) {
    this(new HTTPChaosStatus(), validationEnabled);
  }
  public HTTPChaosStatusBuilder(HTTPChaosStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPChaosStatusBuilder(HTTPChaosStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPChaosStatus(), validationEnabled);
  }
  public HTTPChaosStatusBuilder(HTTPChaosStatusFluent<?> fluent,HTTPChaosStatus instance) {
    this(fluent, instance, false);
  }
  public HTTPChaosStatusBuilder(HTTPChaosStatusFluent<?> fluent,HTTPChaosStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new HTTPChaosStatus());

    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withExperiment(instance.getExperiment());
      fluent.withInstances(instance.getInstances());
      fluent.withConditions(instance.getConditions());
      fluent.withExperiment(instance.getExperiment());
      fluent.withInstances(instance.getInstances());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HTTPChaosStatusBuilder(HTTPChaosStatus instance) {
    this(instance,false);
  }
  public HTTPChaosStatusBuilder(HTTPChaosStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new HTTPChaosStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withExperiment(instance.getExperiment());
      this.withInstances(instance.getInstances());
      this.withConditions(instance.getConditions());
      this.withExperiment(instance.getExperiment());
      this.withInstances(instance.getInstances());
    }
    this.validationEnabled = validationEnabled; 
  }
  HTTPChaosStatusFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPChaosStatus build() {
    HTTPChaosStatus buildable = new HTTPChaosStatus(fluent.buildConditions(),fluent.buildExperiment(),fluent.getInstances());
    return buildable;
  }
  
}