package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GCPChaosBuilder extends GCPChaosFluent<GCPChaosBuilder> implements VisitableBuilder<GCPChaos,GCPChaosBuilder>{
  public GCPChaosBuilder() {
    this(false);
  }
  public GCPChaosBuilder(Boolean validationEnabled) {
    this(new GCPChaos(), validationEnabled);
  }
  public GCPChaosBuilder(GCPChaosFluent<?> fluent) {
    this(fluent, false);
  }
  public GCPChaosBuilder(GCPChaosFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GCPChaos(), validationEnabled);
  }
  public GCPChaosBuilder(GCPChaosFluent<?> fluent,GCPChaos instance) {
    this(fluent, instance, false);
  }
  public GCPChaosBuilder(GCPChaosFluent<?> fluent,GCPChaos instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GCPChaos());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GCPChaosBuilder(GCPChaos instance) {
    this(instance,false);
  }
  public GCPChaosBuilder(GCPChaos instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GCPChaos());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  GCPChaosFluent<?> fluent;
  Boolean validationEnabled;
  public GCPChaos build() {
    GCPChaos buildable = new GCPChaos(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}