package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FrameBuilder extends FrameFluent<FrameBuilder> implements VisitableBuilder<Frame,FrameBuilder>{
  public FrameBuilder() {
    this(false);
  }
  public FrameBuilder(Boolean validationEnabled) {
    this(new Frame(), validationEnabled);
  }
  public FrameBuilder(FrameFluent<?> fluent) {
    this(fluent, false);
  }
  public FrameBuilder(FrameFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Frame(), validationEnabled);
  }
  public FrameBuilder(FrameFluent<?> fluent,Frame instance) {
    this(fluent, instance, false);
  }
  public FrameBuilder(FrameFluent<?> fluent,Frame instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Frame());

    if (instance != null) {
      fluent.withFuncname(instance.getFuncname());
      fluent.withParameters(instance.getParameters());
      fluent.withPredicate(instance.getPredicate());
      fluent.withFuncname(instance.getFuncname());
      fluent.withParameters(instance.getParameters());
      fluent.withPredicate(instance.getPredicate());
    }
    this.validationEnabled = validationEnabled; 
  }
  public FrameBuilder(Frame instance) {
    this(instance,false);
  }
  public FrameBuilder(Frame instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Frame());

    if (instance != null) {
      this.withFuncname(instance.getFuncname());
      this.withParameters(instance.getParameters());
      this.withPredicate(instance.getPredicate());
      this.withFuncname(instance.getFuncname());
      this.withParameters(instance.getParameters());
      this.withPredicate(instance.getPredicate());
    }
    this.validationEnabled = validationEnabled; 
  }
  FrameFluent<?> fluent;
  Boolean validationEnabled;
  public Frame build() {
    Frame buildable = new Frame(fluent.getFuncname(),fluent.getParameters(),fluent.getPredicate());
    return buildable;
  }
  
}