package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AWSChaosStatusBuilder extends AWSChaosStatusFluent<AWSChaosStatusBuilder> implements VisitableBuilder<AWSChaosStatus,AWSChaosStatusBuilder>{
  public AWSChaosStatusBuilder() {
    this(false);
  }
  public AWSChaosStatusBuilder(Boolean validationEnabled) {
    this(new AWSChaosStatus(), validationEnabled);
  }
  public AWSChaosStatusBuilder(AWSChaosStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSChaosStatusBuilder(AWSChaosStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AWSChaosStatus(), validationEnabled);
  }
  public AWSChaosStatusBuilder(AWSChaosStatusFluent<?> fluent,AWSChaosStatus instance) {
    this(fluent, instance, false);
  }
  public AWSChaosStatusBuilder(AWSChaosStatusFluent<?> fluent,AWSChaosStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AWSChaosStatus());

    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withExperiment(instance.getExperiment());
      fluent.withConditions(instance.getConditions());
      fluent.withExperiment(instance.getExperiment());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AWSChaosStatusBuilder(AWSChaosStatus instance) {
    this(instance,false);
  }
  public AWSChaosStatusBuilder(AWSChaosStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AWSChaosStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withExperiment(instance.getExperiment());
      this.withConditions(instance.getConditions());
      this.withExperiment(instance.getExperiment());
    }
    this.validationEnabled = validationEnabled; 
  }
  AWSChaosStatusFluent<?> fluent;
  Boolean validationEnabled;
  public AWSChaosStatus build() {
    AWSChaosStatus buildable = new AWSChaosStatus(fluent.buildConditions(),fluent.buildExperiment());
    return buildable;
  }
  
}