package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AWSChaosBuilder extends AWSChaosFluent<AWSChaosBuilder> implements VisitableBuilder<AWSChaos,AWSChaosBuilder>{
  public AWSChaosBuilder() {
    this(false);
  }
  public AWSChaosBuilder(Boolean validationEnabled) {
    this(new AWSChaos(), validationEnabled);
  }
  public AWSChaosBuilder(AWSChaosFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSChaosBuilder(AWSChaosFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AWSChaos(), validationEnabled);
  }
  public AWSChaosBuilder(AWSChaosFluent<?> fluent,AWSChaos instance) {
    this(fluent, instance, false);
  }
  public AWSChaosBuilder(AWSChaosFluent<?> fluent,AWSChaos instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AWSChaos());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AWSChaosBuilder(AWSChaos instance) {
    this(instance,false);
  }
  public AWSChaosBuilder(AWSChaos instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AWSChaos());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  AWSChaosFluent<?> fluent;
  Boolean validationEnabled;
  public AWSChaos build() {
    AWSChaos buildable = new AWSChaos(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}