package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TimeChaosBuilder extends TimeChaosFluentImpl<TimeChaosBuilder> implements VisitableBuilder<TimeChaos,TimeChaosBuilder>{
  public TimeChaosBuilder() {
    this(false);
  }
  public TimeChaosBuilder(Boolean validationEnabled) {
    this(new TimeChaos(), validationEnabled);
  }
  public TimeChaosBuilder(TimeChaosFluent<?> fluent) {
    this(fluent, false);
  }
  public TimeChaosBuilder(TimeChaosFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TimeChaos(), validationEnabled);
  }
  public TimeChaosBuilder(TimeChaosFluent<?> fluent,TimeChaos instance) {
    this(fluent, instance, false);
  }
  public TimeChaosBuilder(TimeChaosFluent<?> fluent,TimeChaos instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TimeChaosBuilder(TimeChaos instance) {
    this(instance,false);
  }
  public TimeChaosBuilder(TimeChaos instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  TimeChaosFluent<?> fluent;
  Boolean validationEnabled;
  public TimeChaos build() {
    TimeChaos buildable = new TimeChaos(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}