package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodIOChaosStatusBuilder extends PodIOChaosStatusFluentImpl<PodIOChaosStatusBuilder> implements VisitableBuilder<PodIOChaosStatus,PodIOChaosStatusBuilder>{
  public PodIOChaosStatusBuilder() {
    this(false);
  }
  public PodIOChaosStatusBuilder(Boolean validationEnabled) {
    this(new PodIOChaosStatus(), validationEnabled);
  }
  public PodIOChaosStatusBuilder(PodIOChaosStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PodIOChaosStatusBuilder(PodIOChaosStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodIOChaosStatus(), validationEnabled);
  }
  public PodIOChaosStatusBuilder(PodIOChaosStatusFluent<?> fluent,PodIOChaosStatus instance) {
    this(fluent, instance, false);
  }
  public PodIOChaosStatusBuilder(PodIOChaosStatusFluent<?> fluent,PodIOChaosStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withFailedMessage(instance.getFailedMessage());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withPid(instance.getPid());
      fluent.withStartTime(instance.getStartTime());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodIOChaosStatusBuilder(PodIOChaosStatus instance) {
    this(instance,false);
  }
  public PodIOChaosStatusBuilder(PodIOChaosStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withFailedMessage(instance.getFailedMessage());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withPid(instance.getPid());
      this.withStartTime(instance.getStartTime());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodIOChaosStatusFluent<?> fluent;
  Boolean validationEnabled;
  public PodIOChaosStatus build() {
    PodIOChaosStatus buildable = new PodIOChaosStatus(fluent.getFailedMessage(),fluent.getObservedGeneration(),fluent.getPid(),fluent.getStartTime());
    return buildable;
  }
  
}