package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PhysicalMachineChaosSpecBuilder extends PhysicalMachineChaosSpecFluentImpl<PhysicalMachineChaosSpecBuilder> implements VisitableBuilder<PhysicalMachineChaosSpec,PhysicalMachineChaosSpecBuilder>{
  public PhysicalMachineChaosSpecBuilder() {
    this(false);
  }
  public PhysicalMachineChaosSpecBuilder(Boolean validationEnabled) {
    this(new PhysicalMachineChaosSpec(), validationEnabled);
  }
  public PhysicalMachineChaosSpecBuilder(PhysicalMachineChaosSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PhysicalMachineChaosSpecBuilder(PhysicalMachineChaosSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PhysicalMachineChaosSpec(), validationEnabled);
  }
  public PhysicalMachineChaosSpecBuilder(PhysicalMachineChaosSpecFluent<?> fluent,PhysicalMachineChaosSpec instance) {
    this(fluent, instance, false);
  }
  public PhysicalMachineChaosSpecBuilder(PhysicalMachineChaosSpecFluent<?> fluent,PhysicalMachineChaosSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAction(instance.getAction());
      fluent.withAddress(instance.getAddress());
      fluent.withClock(instance.getClock());
      fluent.withDiskFill(instance.getDiskFill());
      fluent.withDiskReadPayload(instance.getDiskReadPayload());
      fluent.withDiskWritePayload(instance.getDiskWritePayload());
      fluent.withDuration(instance.getDuration());
      fluent.withJvmException(instance.getJvmException());
      fluent.withJvmGc(instance.getJvmGc());
      fluent.withJvmLatency(instance.getJvmLatency());
      fluent.withJvmReturn(instance.getJvmReturn());
      fluent.withJvmRuleData(instance.getJvmRuleData());
      fluent.withJvmStress(instance.getJvmStress());
      fluent.withMode(instance.getMode());
      fluent.withNetworkBandwidth(instance.getNetworkBandwidth());
      fluent.withNetworkCorrupt(instance.getNetworkCorrupt());
      fluent.withNetworkDelay(instance.getNetworkDelay());
      fluent.withNetworkDns(instance.getNetworkDns());
      fluent.withNetworkDuplicate(instance.getNetworkDuplicate());
      fluent.withNetworkLoss(instance.getNetworkLoss());
      fluent.withNetworkPartition(instance.getNetworkPartition());
      fluent.withProcess(instance.getProcess());
      fluent.withSelector(instance.getSelector());
      fluent.withStressCpu(instance.getStressCpu());
      fluent.withStressMem(instance.getStressMem());
      fluent.withUid(instance.getUid());
      fluent.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PhysicalMachineChaosSpecBuilder(PhysicalMachineChaosSpec instance) {
    this(instance,false);
  }
  public PhysicalMachineChaosSpecBuilder(PhysicalMachineChaosSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAction(instance.getAction());
      this.withAddress(instance.getAddress());
      this.withClock(instance.getClock());
      this.withDiskFill(instance.getDiskFill());
      this.withDiskReadPayload(instance.getDiskReadPayload());
      this.withDiskWritePayload(instance.getDiskWritePayload());
      this.withDuration(instance.getDuration());
      this.withJvmException(instance.getJvmException());
      this.withJvmGc(instance.getJvmGc());
      this.withJvmLatency(instance.getJvmLatency());
      this.withJvmReturn(instance.getJvmReturn());
      this.withJvmRuleData(instance.getJvmRuleData());
      this.withJvmStress(instance.getJvmStress());
      this.withMode(instance.getMode());
      this.withNetworkBandwidth(instance.getNetworkBandwidth());
      this.withNetworkCorrupt(instance.getNetworkCorrupt());
      this.withNetworkDelay(instance.getNetworkDelay());
      this.withNetworkDns(instance.getNetworkDns());
      this.withNetworkDuplicate(instance.getNetworkDuplicate());
      this.withNetworkLoss(instance.getNetworkLoss());
      this.withNetworkPartition(instance.getNetworkPartition());
      this.withProcess(instance.getProcess());
      this.withSelector(instance.getSelector());
      this.withStressCpu(instance.getStressCpu());
      this.withStressMem(instance.getStressMem());
      this.withUid(instance.getUid());
      this.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  PhysicalMachineChaosSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PhysicalMachineChaosSpec build() {
    PhysicalMachineChaosSpec buildable = new PhysicalMachineChaosSpec(fluent.getAction(),fluent.getAddress(),fluent.getClock(),fluent.getDiskFill(),fluent.getDiskReadPayload(),fluent.getDiskWritePayload(),fluent.getDuration(),fluent.getJvmException(),fluent.getJvmGc(),fluent.getJvmLatency(),fluent.getJvmReturn(),fluent.getJvmRuleData(),fluent.getJvmStress(),fluent.getMode(),fluent.getNetworkBandwidth(),fluent.getNetworkCorrupt(),fluent.getNetworkDelay(),fluent.getNetworkDns(),fluent.getNetworkDuplicate(),fluent.getNetworkLoss(),fluent.getNetworkPartition(),fluent.getProcess(),fluent.getSelector(),fluent.getStressCpu(),fluent.getStressMem(),fluent.getUid(),fluent.getValue());
    return buildable;
  }
  
}