package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkChaosStatusBuilder extends NetworkChaosStatusFluentImpl<NetworkChaosStatusBuilder> implements VisitableBuilder<NetworkChaosStatus,NetworkChaosStatusBuilder>{
  public NetworkChaosStatusBuilder() {
    this(false);
  }
  public NetworkChaosStatusBuilder(Boolean validationEnabled) {
    this(new NetworkChaosStatus(), validationEnabled);
  }
  public NetworkChaosStatusBuilder(NetworkChaosStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkChaosStatusBuilder(NetworkChaosStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NetworkChaosStatus(), validationEnabled);
  }
  public NetworkChaosStatusBuilder(NetworkChaosStatusFluent<?> fluent,NetworkChaosStatus instance) {
    this(fluent, instance, false);
  }
  public NetworkChaosStatusBuilder(NetworkChaosStatusFluent<?> fluent,NetworkChaosStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withExperiment(instance.getExperiment());
      fluent.withInstances(instance.getInstances());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NetworkChaosStatusBuilder(NetworkChaosStatus instance) {
    this(instance,false);
  }
  public NetworkChaosStatusBuilder(NetworkChaosStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withExperiment(instance.getExperiment());
      this.withInstances(instance.getInstances());
    }
    this.validationEnabled = validationEnabled; 
  }
  NetworkChaosStatusFluent<?> fluent;
  Boolean validationEnabled;
  public NetworkChaosStatus build() {
    NetworkChaosStatus buildable = new NetworkChaosStatus(fluent.getConditions(),fluent.getExperiment(),fluent.getInstances());
    return buildable;
  }
  
}