package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KernelChaosListBuilder extends KernelChaosListFluentImpl<KernelChaosListBuilder> implements VisitableBuilder<KernelChaosList,KernelChaosListBuilder>{
  public KernelChaosListBuilder() {
    this(false);
  }
  public KernelChaosListBuilder(Boolean validationEnabled) {
    this(new KernelChaosList(), validationEnabled);
  }
  public KernelChaosListBuilder(KernelChaosListFluent<?> fluent) {
    this(fluent, false);
  }
  public KernelChaosListBuilder(KernelChaosListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KernelChaosList(), validationEnabled);
  }
  public KernelChaosListBuilder(KernelChaosListFluent<?> fluent,KernelChaosList instance) {
    this(fluent, instance, false);
  }
  public KernelChaosListBuilder(KernelChaosListFluent<?> fluent,KernelChaosList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KernelChaosListBuilder(KernelChaosList instance) {
    this(instance,false);
  }
  public KernelChaosListBuilder(KernelChaosList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  KernelChaosListFluent<?> fluent;
  Boolean validationEnabled;
  public KernelChaosList build() {
    KernelChaosList buildable = new KernelChaosList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}