package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JVMLatencySpecBuilder extends JVMLatencySpecFluentImpl<JVMLatencySpecBuilder> implements VisitableBuilder<JVMLatencySpec,JVMLatencySpecBuilder>{
  public JVMLatencySpecBuilder() {
    this(false);
  }
  public JVMLatencySpecBuilder(Boolean validationEnabled) {
    this(new JVMLatencySpec(), validationEnabled);
  }
  public JVMLatencySpecBuilder(JVMLatencySpecFluent<?> fluent) {
    this(fluent, false);
  }
  public JVMLatencySpecBuilder(JVMLatencySpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new JVMLatencySpec(), validationEnabled);
  }
  public JVMLatencySpecBuilder(JVMLatencySpecFluent<?> fluent,JVMLatencySpec instance) {
    this(fluent, instance, false);
  }
  public JVMLatencySpecBuilder(JVMLatencySpecFluent<?> fluent,JVMLatencySpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withClassName(instance.getClassName());
      fluent.withLatency(instance.getLatency());
      fluent.withMethod(instance.getMethod());
      fluent.withPid(instance.getPid());
      fluent.withPort(instance.getPort());
    }
    this.validationEnabled = validationEnabled; 
  }
  public JVMLatencySpecBuilder(JVMLatencySpec instance) {
    this(instance,false);
  }
  public JVMLatencySpecBuilder(JVMLatencySpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withClassName(instance.getClassName());
      this.withLatency(instance.getLatency());
      this.withMethod(instance.getMethod());
      this.withPid(instance.getPid());
      this.withPort(instance.getPort());
    }
    this.validationEnabled = validationEnabled; 
  }
  JVMLatencySpecFluent<?> fluent;
  Boolean validationEnabled;
  public JVMLatencySpec build() {
    JVMLatencySpec buildable = new JVMLatencySpec(fluent.getClassName(),fluent.getLatency(),fluent.getMethod(),fluent.getPid(),fluent.getPort());
    return buildable;
  }
  
}