package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GCPChaosListBuilder extends GCPChaosListFluentImpl<GCPChaosListBuilder> implements VisitableBuilder<GCPChaosList,GCPChaosListBuilder>{
  public GCPChaosListBuilder() {
    this(false);
  }
  public GCPChaosListBuilder(Boolean validationEnabled) {
    this(new GCPChaosList(), validationEnabled);
  }
  public GCPChaosListBuilder(GCPChaosListFluent<?> fluent) {
    this(fluent, false);
  }
  public GCPChaosListBuilder(GCPChaosListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GCPChaosList(), validationEnabled);
  }
  public GCPChaosListBuilder(GCPChaosListFluent<?> fluent,GCPChaosList instance) {
    this(fluent, instance, false);
  }
  public GCPChaosListBuilder(GCPChaosListFluent<?> fluent,GCPChaosList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GCPChaosListBuilder(GCPChaosList instance) {
    this(instance,false);
  }
  public GCPChaosListBuilder(GCPChaosList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  GCPChaosListFluent<?> fluent;
  Boolean validationEnabled;
  public GCPChaosList build() {
    GCPChaosList buildable = new GCPChaosList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}